<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TauxAssurePret StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TauxAssurePret
 * @subpackage Structs
 */
class TauxAssurePret extends AbstractStructBase
{
    /**
     * The NumPret
     * @var int
     */
    public $NumPret;
    /**
     * The TypeTaux
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TypeTaux;
    /**
     * The Taux
     * @var float
     */
    public $Taux;
    /**
     * Constructor method for TauxAssurePret
     * @uses TauxAssurePret::setNumPret()
     * @uses TauxAssurePret::setTypeTaux()
     * @uses TauxAssurePret::setTaux()
     * @param int $numPret
     * @param string $typeTaux
     * @param float $taux
     */
    public function __construct($numPret = null, $typeTaux = null, $taux = null)
    {
        $this
            ->setNumPret($numPret)
            ->setTypeTaux($typeTaux)
            ->setTaux($taux);
    }
    /**
     * Get NumPret value
     * @return int|null
     */
    public function getNumPret()
    {
        return $this->NumPret;
    }
    /**
     * Set NumPret value
     * @param int $numPret
     * @return TauxAssurePret
     */
    public function setNumPret($numPret = null)
    {
        // validation for constraint: int
        if (!is_null($numPret) && !(is_int($numPret) || ctype_digit($numPret))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numPret, true), gettype($numPret)), __LINE__);
        }
        $this->NumPret = $numPret;
        return $this;
    }
    /**
     * Get TypeTaux value
     * @return string|null
     */
    public function getTypeTaux()
    {
        return $this->TypeTaux;
    }
    /**
     * Set TypeTaux value
     * @param string $typeTaux
     * @return TauxAssurePret
     */
    public function setTypeTaux($typeTaux = null)
    {
        // validation for constraint: string
        if (!is_null($typeTaux) && !is_string($typeTaux)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeTaux, true), gettype($typeTaux)), __LINE__);
        }
        $this->TypeTaux = $typeTaux;
        return $this;
    }
    /**
     * Get Taux value
     * @return float|null
     */
    public function getTaux()
    {
        return $this->Taux;
    }
    /**
     * Set Taux value
     * @param float $taux
     * @return TauxAssurePret
     */
    public function setTaux($taux = null)
    {
        // validation for constraint: float
        if (!is_null($taux) && !(is_float($taux) || is_numeric($taux))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux, true), gettype($taux)), __LINE__);
        }
        $this->Taux = $taux;
        return $this;
    }
}
