<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfessionData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProfessionData
 * @subpackage Structs
 */
class ProfessionData extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Libelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Libelle;
    /**
     * Constructor method for ProfessionData
     * @uses ProfessionData::setID()
     * @uses ProfessionData::setLibelle()
     * @param int $iD
     * @param string $libelle
     */
    public function __construct($iD = null, $libelle = null)
    {
        $this
            ->setID($iD)
            ->setLibelle($libelle);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return ProfessionData
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Libelle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLibelle()
    {
        return isset($this->Libelle) ? $this->Libelle : null;
    }
    /**
     * Set Libelle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $libelle
     * @return ProfessionData
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libelle, true), gettype($libelle)), __LINE__);
        }
        if (is_null($libelle) || (is_array($libelle) && empty($libelle))) {
            unset($this->Libelle);
        } else {
            $this->Libelle = $libelle;
        }
        return $this;
    }
}
