<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PretData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PretData
 * @subpackage Structs
 */
class PretData extends AbstractStructBase
{
    /**
     * The Differe
     * @var int
     */
    public $Differe;
    /**
     * The Duree
     * @var int
     */
    public $Duree;
    /**
     * The Montant
     * @var float
     */
    public $Montant;
    /**
     * The Numero
     * @var int
     */
    public $Numero;
    /**
     * The Paliers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfPalierPretData
     */
    public $Paliers;
    /**
     * The Taux
     * @var float
     */
    public $Taux;
    /**
     * The TauxInfine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TauxInfine;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The ValeurResiduelle
     * @var float
     */
    public $ValeurResiduelle;
    /**
     * Constructor method for PretData
     * @uses PretData::setDiffere()
     * @uses PretData::setDuree()
     * @uses PretData::setMontant()
     * @uses PretData::setNumero()
     * @uses PretData::setPaliers()
     * @uses PretData::setTaux()
     * @uses PretData::setTauxInfine()
     * @uses PretData::setType()
     * @uses PretData::setValeurResiduelle()
     * @param int $differe
     * @param int $duree
     * @param float $montant
     * @param int $numero
     * @param ArrayOfPalierPretData $paliers
     * @param float $taux
     * @param float $tauxInfine
     * @param string $type
     * @param float $valeurResiduelle
     */
    public function __construct($differe = null, $duree = null, $montant = null, $numero = null, ArrayOfPalierPretData $paliers = null, $taux = null, $tauxInfine = null, $type = null, $valeurResiduelle = null)
    {
        $this
            ->setDiffere($differe)
            ->setDuree($duree)
            ->setMontant($montant)
            ->setNumero($numero)
            ->setPaliers($paliers)
            ->setTaux($taux)
            ->setTauxInfine($tauxInfine)
            ->setType($type)
            ->setValeurResiduelle($valeurResiduelle);
    }
    /**
     * Get Differe value
     * @return int|null
     */
    public function getDiffere()
    {
        return $this->Differe;
    }
    /**
     * Set Differe value
     * @param int $differe
     * @return PretData
     */
    public function setDiffere($differe = null)
    {
        // validation for constraint: int
        if (!is_null($differe) && !(is_int($differe) || ctype_digit($differe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($differe, true), gettype($differe)), __LINE__);
        }
        $this->Differe = $differe;
        return $this;
    }
    /**
     * Get Duree value
     * @return int|null
     */
    public function getDuree()
    {
        return $this->Duree;
    }
    /**
     * Set Duree value
     * @param int $duree
     * @return PretData
     */
    public function setDuree($duree = null)
    {
        // validation for constraint: int
        if (!is_null($duree) && !(is_int($duree) || ctype_digit($duree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duree, true), gettype($duree)), __LINE__);
        }
        $this->Duree = $duree;
        return $this;
    }
    /**
     * Get Montant value
     * @return float|null
     */
    public function getMontant()
    {
        return $this->Montant;
    }
    /**
     * Set Montant value
     * @param float $montant
     * @return PretData
     */
    public function setMontant($montant = null)
    {
        // validation for constraint: float
        if (!is_null($montant) && !(is_float($montant) || is_numeric($montant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant, true), gettype($montant)), __LINE__);
        }
        $this->Montant = $montant;
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return PretData
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Paliers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfPalierPretData|null
     */
    public function getPaliers()
    {
        return isset($this->Paliers) ? $this->Paliers : null;
    }
    /**
     * Set Paliers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfPalierPretData $paliers
     * @return PretData
     */
    public function setPaliers(ArrayOfPalierPretData $paliers = null)
    {
        if (is_null($paliers) || (is_array($paliers) && empty($paliers))) {
            unset($this->Paliers);
        } else {
            $this->Paliers = $paliers;
        }
        return $this;
    }
    /**
     * Get Taux value
     * @return float|null
     */
    public function getTaux()
    {
        return $this->Taux;
    }
    /**
     * Set Taux value
     * @param float $taux
     * @return PretData
     */
    public function setTaux($taux = null)
    {
        // validation for constraint: float
        if (!is_null($taux) && !(is_float($taux) || is_numeric($taux))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux, true), gettype($taux)), __LINE__);
        }
        $this->Taux = $taux;
        return $this;
    }
    /**
     * Get TauxInfine value
     * @return float|null
     */
    public function getTauxInfine()
    {
        return $this->TauxInfine;
    }
    /**
     * Set TauxInfine value
     * @param float $tauxInfine
     * @return PretData
     */
    public function setTauxInfine($tauxInfine = null)
    {
        // validation for constraint: float
        if (!is_null($tauxInfine) && !(is_float($tauxInfine) || is_numeric($tauxInfine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tauxInfine, true), gettype($tauxInfine)), __LINE__);
        }
        $this->TauxInfine = $tauxInfine;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return PretData
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ValeurResiduelle value
     * @return float|null
     */
    public function getValeurResiduelle()
    {
        return $this->ValeurResiduelle;
    }
    /**
     * Set ValeurResiduelle value
     * @param float $valeurResiduelle
     * @return PretData
     */
    public function setValeurResiduelle($valeurResiduelle = null)
    {
        // validation for constraint: float
        if (!is_null($valeurResiduelle) && !(is_float($valeurResiduelle) || is_numeric($valeurResiduelle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valeurResiduelle, true), gettype($valeurResiduelle)), __LINE__);
        }
        $this->ValeurResiduelle = $valeurResiduelle;
        return $this;
    }
}
