<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateSimulationData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateSimulationData $parameters
     * @return CreateSimulationDataResponse|bool
     */
    public function CreateSimulationData(CreateSimulationData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSimulationData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CreateSimulationDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
