<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CotisationRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CotisationRow
 * @subpackage Structs
 */
class CotisationRow extends AbstractStructBase
{
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The Annee
     * @var int
     */
    public $Annee;
    /**
     * The Cotisations
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfCotisationData
     */
    public $Cotisations;
    /**
     * The FrAcquisition
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $FrAcquisition;
    /**
     * The FrGestion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FrGestion;
    /**
     * The FrIntermediation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FrIntermediation;
    /**
     * The MontantKRD
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $MontantKRD;
    /**
     * The Pret
     * @var int
     */
    public $Pret;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Taxes;
    /**
     * The Total
     * @var float
     */
    public $Total;
    /**
     * Constructor method for CotisationRow
     * @uses CotisationRow::setAge()
     * @uses CotisationRow::setAnnee()
     * @uses CotisationRow::setCotisations()
     * @uses CotisationRow::setFrAcquisition()
     * @uses CotisationRow::setFrGestion()
     * @uses CotisationRow::setFrIntermediation()
     * @uses CotisationRow::setMontantKRD()
     * @uses CotisationRow::setPret()
     * @uses CotisationRow::setTaxes()
     * @uses CotisationRow::setTotal()
     * @param int $age
     * @param int $annee
     * @param ArrayOfCotisationData $cotisations
     * @param float $frAcquisition
     * @param float $frGestion
     * @param float $frIntermediation
     * @param float $montantKRD
     * @param int $pret
     * @param float $taxes
     * @param float $total
     */
    public function __construct($age = null, $annee = null, ArrayOfCotisationData $cotisations = null, $frAcquisition = null, $frGestion = null, $frIntermediation = null, $montantKRD = null, $pret = null, $taxes = null, $total = null)
    {
        $this
            ->setAge($age)
            ->setAnnee($annee)
            ->setCotisations($cotisations)
            ->setFrAcquisition($frAcquisition)
            ->setFrGestion($frGestion)
            ->setFrIntermediation($frIntermediation)
            ->setMontantKRD($montantKRD)
            ->setPret($pret)
            ->setTaxes($taxes)
            ->setTotal($total);
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return CotisationRow
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Annee value
     * @return int|null
     */
    public function getAnnee()
    {
        return $this->Annee;
    }
    /**
     * Set Annee value
     * @param int $annee
     * @return CotisationRow
     */
    public function setAnnee($annee = null)
    {
        // validation for constraint: int
        if (!is_null($annee) && !(is_int($annee) || ctype_digit($annee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annee, true), gettype($annee)), __LINE__);
        }
        $this->Annee = $annee;
        return $this;
    }
    /**
     * Get Cotisations value
     * @return ArrayOfCotisationData|null
     */
    public function getCotisations()
    {
        return $this->Cotisations;
    }
    /**
     * Set Cotisations value
     * @param ArrayOfCotisationData $cotisations
     * @return CotisationRow
     */
    public function setCotisations(ArrayOfCotisationData $cotisations = null)
    {
        $this->Cotisations = $cotisations;
        return $this;
    }
    /**
     * Get FrAcquisition value
     * @return float|null
     */
    public function getFrAcquisition()
    {
        return $this->FrAcquisition;
    }
    /**
     * Set FrAcquisition value
     * @param float $frAcquisition
     * @return CotisationRow
     */
    public function setFrAcquisition($frAcquisition = null)
    {
        // validation for constraint: float
        if (!is_null($frAcquisition) && !(is_float($frAcquisition) || is_numeric($frAcquisition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frAcquisition, true), gettype($frAcquisition)), __LINE__);
        }
        $this->FrAcquisition = $frAcquisition;
        return $this;
    }
    /**
     * Get FrGestion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFrGestion()
    {
        return isset($this->FrGestion) ? $this->FrGestion : null;
    }
    /**
     * Set FrGestion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $frGestion
     * @return CotisationRow
     */
    public function setFrGestion($frGestion = null)
    {
        // validation for constraint: float
        if (!is_null($frGestion) && !(is_float($frGestion) || is_numeric($frGestion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frGestion, true), gettype($frGestion)), __LINE__);
        }
        if (is_null($frGestion) || (is_array($frGestion) && empty($frGestion))) {
            unset($this->FrGestion);
        } else {
            $this->FrGestion = $frGestion;
        }
        return $this;
    }
    /**
     * Get FrIntermediation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFrIntermediation()
    {
        return isset($this->FrIntermediation) ? $this->FrIntermediation : null;
    }
    /**
     * Set FrIntermediation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $frIntermediation
     * @return CotisationRow
     */
    public function setFrIntermediation($frIntermediation = null)
    {
        // validation for constraint: float
        if (!is_null($frIntermediation) && !(is_float($frIntermediation) || is_numeric($frIntermediation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frIntermediation, true), gettype($frIntermediation)), __LINE__);
        }
        if (is_null($frIntermediation) || (is_array($frIntermediation) && empty($frIntermediation))) {
            unset($this->FrIntermediation);
        } else {
            $this->FrIntermediation = $frIntermediation;
        }
        return $this;
    }
    /**
     * Get MontantKRD value
     * @return float|null
     */
    public function getMontantKRD()
    {
        return $this->MontantKRD;
    }
    /**
     * Set MontantKRD value
     * @param float $montantKRD
     * @return CotisationRow
     */
    public function setMontantKRD($montantKRD = null)
    {
        // validation for constraint: float
        if (!is_null($montantKRD) && !(is_float($montantKRD) || is_numeric($montantKRD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantKRD, true), gettype($montantKRD)), __LINE__);
        }
        $this->MontantKRD = $montantKRD;
        return $this;
    }
    /**
     * Get Pret value
     * @return int|null
     */
    public function getPret()
    {
        return $this->Pret;
    }
    /**
     * Set Pret value
     * @param int $pret
     * @return CotisationRow
     */
    public function setPret($pret = null)
    {
        // validation for constraint: int
        if (!is_null($pret) && !(is_int($pret) || ctype_digit($pret))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pret, true), gettype($pret)), __LINE__);
        }
        $this->Pret = $pret;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return CotisationRow
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: float
        if (!is_null($taxes) && !(is_float($taxes) || is_numeric($taxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return CotisationRow
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
}
