<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurprimeData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SurprimeData
 * @subpackage Structs
 */
class SurprimeData extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Taux
     * @var float
     */
    public $Taux;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for SurprimeData
     * @uses SurprimeData::setCode()
     * @uses SurprimeData::setTaux()
     * @uses SurprimeData::setType()
     * @param string $code
     * @param float $taux
     * @param string $type
     */
    public function __construct($code = null, $taux = null, $type = null)
    {
        $this
            ->setCode($code)
            ->setTaux($taux)
            ->setType($type);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return SurprimeData
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Taux value
     * @return float|null
     */
    public function getTaux()
    {
        return $this->Taux;
    }
    /**
     * Set Taux value
     * @param float $taux
     * @return SurprimeData
     */
    public function setTaux($taux = null)
    {
        // validation for constraint: float
        if (!is_null($taux) && !(is_float($taux) || is_numeric($taux))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux, true), gettype($taux)), __LINE__);
        }
        $this->Taux = $taux;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return SurprimeData
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
