<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimulationDataMT StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SimulationDataMT
 * @subpackage Structs
 */
class SimulationDataMT extends AbstractStructBase
{
    /**
     * The Assures
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfAssureData
     */
    public $Assures;
    /**
     * The CodeLangue
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeLangue;
    /**
     * The CotisationType
     * @var string
     */
    public $CotisationType;
    /**
     * The DateEffet
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DateEffet;
    /**
     * The Periodicite
     * @var string
     */
    public $Periodicite;
    /**
     * The Prets
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfPretData
     */
    public $Prets;
    /**
     * Constructor method for SimulationDataMT
     * @uses SimulationDataMT::setAssures()
     * @uses SimulationDataMT::setCodeLangue()
     * @uses SimulationDataMT::setCotisationType()
     * @uses SimulationDataMT::setDateEffet()
     * @uses SimulationDataMT::setPeriodicite()
     * @uses SimulationDataMT::setPrets()
     * @param ArrayOfAssureData $assures
     * @param string $codeLangue
     * @param string $cotisationType
     * @param string $dateEffet
     * @param string $periodicite
     * @param ArrayOfPretData $prets
     */
    public function __construct(ArrayOfAssureData $assures = null, $codeLangue = null, $cotisationType = null, $dateEffet = null, $periodicite = null, ArrayOfPretData $prets = null)
    {
        $this
            ->setAssures($assures)
            ->setCodeLangue($codeLangue)
            ->setCotisationType($cotisationType)
            ->setDateEffet($dateEffet)
            ->setPeriodicite($periodicite)
            ->setPrets($prets);
    }
    /**
     * Get Assures value
     * @return ArrayOfAssureData|null
     */
    public function getAssures()
    {
        return $this->Assures;
    }
    /**
     * Set Assures value
     * @param ArrayOfAssureData $assures
     * @return SimulationDataMT
     */
    public function setAssures(ArrayOfAssureData $assures = null)
    {
        $this->Assures = $assures;
        return $this;
    }
    /**
     * Get CodeLangue value
     * @return string|null
     */
    public function getCodeLangue()
    {
        return $this->CodeLangue;
    }
    /**
     * Set CodeLangue value
     * @param string $codeLangue
     * @return SimulationDataMT
     */
    public function setCodeLangue($codeLangue = null)
    {
        // validation for constraint: string
        if (!is_null($codeLangue) && !is_string($codeLangue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeLangue, true), gettype($codeLangue)), __LINE__);
        }
        $this->CodeLangue = $codeLangue;
        return $this;
    }
    /**
     * Get CotisationType value
     * @return string|null
     */
    public function getCotisationType()
    {
        return $this->CotisationType;
    }
    /**
     * Set CotisationType value
     * @uses TypeCotisation::valueIsValid()
     * @uses TypeCotisation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cotisationType
     * @return SimulationDataMT
     */
    public function setCotisationType($cotisationType = null)
    {
        // validation for constraint: enumeration
        if (!TypeCotisation::valueIsValid($cotisationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class TypeCotisation', is_array($cotisationType) ? implode(', ', $cotisationType) : var_export($cotisationType, true), implode(', ', TypeCotisation::getValidValues())), __LINE__);
        }
        $this->CotisationType = $cotisationType;
        return $this;
    }
    /**
     * Get DateEffet value
     * @return string|null
     */
    public function getDateEffet()
    {
        return $this->DateEffet;
    }
    /**
     * Set DateEffet value
     * @param string $dateEffet
     * @return SimulationDataMT
     */
    public function setDateEffet($dateEffet = null)
    {
        // validation for constraint: string
        if (!is_null($dateEffet) && !is_string($dateEffet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEffet, true), gettype($dateEffet)), __LINE__);
        }
        $this->DateEffet = $dateEffet;
        return $this;
    }
    /**
     * Get Periodicite value
     * @return string|null
     */
    public function getPeriodicite()
    {
        return $this->Periodicite;
    }
    /**
     * Set Periodicite value
     * @uses TypePeriodicite::valueIsValid()
     * @uses TypePeriodicite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicite
     * @return SimulationDataMT
     */
    public function setPeriodicite($periodicite = null)
    {
        // validation for constraint: enumeration
        if (!TypePeriodicite::valueIsValid($periodicite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class TypePeriodicite', is_array($periodicite) ? implode(', ', $periodicite) : var_export($periodicite, true), implode(', ', TypePeriodicite::getValidValues())), __LINE__);
        }
        $this->Periodicite = $periodicite;
        return $this;
    }
    /**
     * Get Prets value
     * @return ArrayOfPretData|null
     */
    public function getPrets()
    {
        return $this->Prets;
    }
    /**
     * Set Prets value
     * @param ArrayOfPretData $prets
     * @return SimulationDataMT
     */
    public function setPrets(ArrayOfPretData $prets = null)
    {
        $this->Prets = $prets;
        return $this;
    }
}
