<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Simulate ServiceType
 * @subpackage Services
 */
class Simulate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Simulate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Simulate $parameters
     * @return SimulateResponse|bool
     */
    public function Simulate(Simulate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Simulate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return SimulateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
