<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveDossierSimulation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SaveDossierSimulation $parameters
     * @return SaveDossierSimulationResponse|bool
     */
    public function SaveDossierSimulation(SaveDossierSimulation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveDossierSimulation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return SaveDossierSimulationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
