<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PalierPretData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PalierPretData
 * @subpackage Structs
 */
class PalierPretData extends AbstractStructBase
{
    /**
     * The Duree
     * @var int
     */
    public $Duree;
    /**
     * The Montant
     * @var float
     */
    public $Montant;
    /**
     * The Taux
     * @var float
     */
    public $Taux;
    /**
     * Constructor method for PalierPretData
     * @uses PalierPretData::setDuree()
     * @uses PalierPretData::setMontant()
     * @uses PalierPretData::setTaux()
     * @param int $duree
     * @param float $montant
     * @param float $taux
     */
    public function __construct($duree = null, $montant = null, $taux = null)
    {
        $this
            ->setDuree($duree)
            ->setMontant($montant)
            ->setTaux($taux);
    }
    /**
     * Get Duree value
     * @return int|null
     */
    public function getDuree()
    {
        return $this->Duree;
    }
    /**
     * Set Duree value
     * @param int $duree
     * @return PalierPretData
     */
    public function setDuree($duree = null)
    {
        // validation for constraint: int
        if (!is_null($duree) && !(is_int($duree) || ctype_digit($duree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duree, true), gettype($duree)), __LINE__);
        }
        $this->Duree = $duree;
        return $this;
    }
    /**
     * Get Montant value
     * @return float|null
     */
    public function getMontant()
    {
        return $this->Montant;
    }
    /**
     * Set Montant value
     * @param float $montant
     * @return PalierPretData
     */
    public function setMontant($montant = null)
    {
        // validation for constraint: float
        if (!is_null($montant) && !(is_float($montant) || is_numeric($montant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant, true), gettype($montant)), __LINE__);
        }
        $this->Montant = $montant;
        return $this;
    }
    /**
     * Get Taux value
     * @return float|null
     */
    public function getTaux()
    {
        return $this->Taux;
    }
    /**
     * Set Taux value
     * @param float $taux
     * @return PalierPretData
     */
    public function setTaux($taux = null)
    {
        // validation for constraint: float
        if (!is_null($taux) && !(is_float($taux) || is_numeric($taux))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux, true), gettype($taux)), __LINE__);
        }
        $this->Taux = $taux;
        return $this;
    }
}
