<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CotisationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CotisationData
 * @subpackage Structs
 */
class CotisationData extends AbstractStructBase
{
    /**
     * The Garantie
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Garantie;
    /**
     * The Prime
     * @var float
     */
    public $Prime;
    /**
     * The PrimeHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PrimeHT;
    /**
     * The Taxe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxe;
    /**
     * The SurprimeMedicalePCHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SurprimeMedicalePCHT;
    /**
     * The SurprimeMedicalePMHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SurprimeMedicalePMHT;
    /**
     * The SurprimeNonMedicalePCHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SurprimeNonMedicalePCHT;
    /**
     * The SurprimeNonMedicalePMHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SurprimeNonMedicalePMHT;
    /**
     * Constructor method for CotisationData
     * @uses CotisationData::setGarantie()
     * @uses CotisationData::setPrime()
     * @uses CotisationData::setPrimeHT()
     * @uses CotisationData::setTaxe()
     * @uses CotisationData::setSurprimeMedicalePCHT()
     * @uses CotisationData::setSurprimeMedicalePMHT()
     * @uses CotisationData::setSurprimeNonMedicalePCHT()
     * @uses CotisationData::setSurprimeNonMedicalePMHT()
     * @param string $garantie
     * @param float $prime
     * @param float $primeHT
     * @param float $taxe
     * @param float $surprimeMedicalePCHT
     * @param float $surprimeMedicalePMHT
     * @param float $surprimeNonMedicalePCHT
     * @param float $surprimeNonMedicalePMHT
     */
    public function __construct($garantie = null, $prime = null, $primeHT = null, $taxe = null, $surprimeMedicalePCHT = null, $surprimeMedicalePMHT = null, $surprimeNonMedicalePCHT = null, $surprimeNonMedicalePMHT = null)
    {
        $this
            ->setGarantie($garantie)
            ->setPrime($prime)
            ->setPrimeHT($primeHT)
            ->setTaxe($taxe)
            ->setSurprimeMedicalePCHT($surprimeMedicalePCHT)
            ->setSurprimeMedicalePMHT($surprimeMedicalePMHT)
            ->setSurprimeNonMedicalePCHT($surprimeNonMedicalePCHT)
            ->setSurprimeNonMedicalePMHT($surprimeNonMedicalePMHT);
    }
    /**
     * Get Garantie value
     * @return string|null
     */
    public function getGarantie()
    {
        return $this->Garantie;
    }
    /**
     * Set Garantie value
     * @param string $garantie
     * @return CotisationData
     */
    public function setGarantie($garantie = null)
    {
        // validation for constraint: string
        if (!is_null($garantie) && !is_string($garantie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($garantie, true), gettype($garantie)), __LINE__);
        }
        $this->Garantie = $garantie;
        return $this;
    }
    /**
     * Get Prime value
     * @return float|null
     */
    public function getPrime()
    {
        return $this->Prime;
    }
    /**
     * Set Prime value
     * @param float $prime
     * @return CotisationData
     */
    public function setPrime($prime = null)
    {
        // validation for constraint: float
        if (!is_null($prime) && !(is_float($prime) || is_numeric($prime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prime, true), gettype($prime)), __LINE__);
        }
        $this->Prime = $prime;
        return $this;
    }
    /**
     * Get PrimeHT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrimeHT()
    {
        return isset($this->PrimeHT) ? $this->PrimeHT : null;
    }
    /**
     * Set PrimeHT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $primeHT
     * @return CotisationData
     */
    public function setPrimeHT($primeHT = null)
    {
        // validation for constraint: float
        if (!is_null($primeHT) && !(is_float($primeHT) || is_numeric($primeHT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primeHT, true), gettype($primeHT)), __LINE__);
        }
        if (is_null($primeHT) || (is_array($primeHT) && empty($primeHT))) {
            unset($this->PrimeHT);
        } else {
            $this->PrimeHT = $primeHT;
        }
        return $this;
    }
    /**
     * Get Taxe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxe()
    {
        return isset($this->Taxe) ? $this->Taxe : null;
    }
    /**
     * Set Taxe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxe
     * @return CotisationData
     */
    public function setTaxe($taxe = null)
    {
        // validation for constraint: float
        if (!is_null($taxe) && !(is_float($taxe) || is_numeric($taxe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxe, true), gettype($taxe)), __LINE__);
        }
        if (is_null($taxe) || (is_array($taxe) && empty($taxe))) {
            unset($this->Taxe);
        } else {
            $this->Taxe = $taxe;
        }
        return $this;
    }
    /**
     * Get SurprimeMedicalePCHT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSurprimeMedicalePCHT()
    {
        return isset($this->SurprimeMedicalePCHT) ? $this->SurprimeMedicalePCHT : null;
    }
    /**
     * Set SurprimeMedicalePCHT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $surprimeMedicalePCHT
     * @return CotisationData
     */
    public function setSurprimeMedicalePCHT($surprimeMedicalePCHT = null)
    {
        // validation for constraint: float
        if (!is_null($surprimeMedicalePCHT) && !(is_float($surprimeMedicalePCHT) || is_numeric($surprimeMedicalePCHT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surprimeMedicalePCHT, true), gettype($surprimeMedicalePCHT)), __LINE__);
        }
        if (is_null($surprimeMedicalePCHT) || (is_array($surprimeMedicalePCHT) && empty($surprimeMedicalePCHT))) {
            unset($this->SurprimeMedicalePCHT);
        } else {
            $this->SurprimeMedicalePCHT = $surprimeMedicalePCHT;
        }
        return $this;
    }
    /**
     * Get SurprimeMedicalePMHT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSurprimeMedicalePMHT()
    {
        return isset($this->SurprimeMedicalePMHT) ? $this->SurprimeMedicalePMHT : null;
    }
    /**
     * Set SurprimeMedicalePMHT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $surprimeMedicalePMHT
     * @return CotisationData
     */
    public function setSurprimeMedicalePMHT($surprimeMedicalePMHT = null)
    {
        // validation for constraint: float
        if (!is_null($surprimeMedicalePMHT) && !(is_float($surprimeMedicalePMHT) || is_numeric($surprimeMedicalePMHT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surprimeMedicalePMHT, true), gettype($surprimeMedicalePMHT)), __LINE__);
        }
        if (is_null($surprimeMedicalePMHT) || (is_array($surprimeMedicalePMHT) && empty($surprimeMedicalePMHT))) {
            unset($this->SurprimeMedicalePMHT);
        } else {
            $this->SurprimeMedicalePMHT = $surprimeMedicalePMHT;
        }
        return $this;
    }
    /**
     * Get SurprimeNonMedicalePCHT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSurprimeNonMedicalePCHT()
    {
        return isset($this->SurprimeNonMedicalePCHT) ? $this->SurprimeNonMedicalePCHT : null;
    }
    /**
     * Set SurprimeNonMedicalePCHT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $surprimeNonMedicalePCHT
     * @return CotisationData
     */
    public function setSurprimeNonMedicalePCHT($surprimeNonMedicalePCHT = null)
    {
        // validation for constraint: float
        if (!is_null($surprimeNonMedicalePCHT) && !(is_float($surprimeNonMedicalePCHT) || is_numeric($surprimeNonMedicalePCHT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surprimeNonMedicalePCHT, true), gettype($surprimeNonMedicalePCHT)), __LINE__);
        }
        if (is_null($surprimeNonMedicalePCHT) || (is_array($surprimeNonMedicalePCHT) && empty($surprimeNonMedicalePCHT))) {
            unset($this->SurprimeNonMedicalePCHT);
        } else {
            $this->SurprimeNonMedicalePCHT = $surprimeNonMedicalePCHT;
        }
        return $this;
    }
    /**
     * Get SurprimeNonMedicalePMHT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSurprimeNonMedicalePMHT()
    {
        return isset($this->SurprimeNonMedicalePMHT) ? $this->SurprimeNonMedicalePMHT : null;
    }
    /**
     * Set SurprimeNonMedicalePMHT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $surprimeNonMedicalePMHT
     * @return CotisationData
     */
    public function setSurprimeNonMedicalePMHT($surprimeNonMedicalePMHT = null)
    {
        // validation for constraint: float
        if (!is_null($surprimeNonMedicalePMHT) && !(is_float($surprimeNonMedicalePMHT) || is_numeric($surprimeNonMedicalePMHT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surprimeNonMedicalePMHT, true), gettype($surprimeNonMedicalePMHT)), __LINE__);
        }
        if (is_null($surprimeNonMedicalePMHT) || (is_array($surprimeNonMedicalePMHT) && empty($surprimeNonMedicalePMHT))) {
            unset($this->SurprimeNonMedicalePMHT);
        } else {
            $this->SurprimeNonMedicalePMHT = $surprimeNonMedicalePMHT;
        }
        return $this;
    }
}
