<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssureData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssureData
 * @subpackage Structs
 */
class AssureData extends AbstractStructBase
{
    /**
     * The Civilite
     * @var string
     */
    public $Civilite;
    /**
     * The DateNaissance
     * @var string
     */
    public $DateNaissance;
    /**
     * The Fumeur
     * @var bool
     */
    public $Fumeur;
    /**
     * The Garanties
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfstring
     */
    public $Garanties;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfstring
     */
    public $Options;
    /**
     * The Poids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Poids;
    /**
     * The ProfessionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfessionID;
    /**
     * The Quotite
     * @var float
     */
    public $Quotite;
    /**
     * The Surprimes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfSurprimeData
     */
    public $Surprimes;
    /**
     * The Taille
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Taille;
    /**
     * The TauxCommission
     * @var float
     */
    public $TauxCommission;
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nom;
    /**
     * The Prenom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prenom;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telephone;
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EMail;
    /**
     * The RisqueProfessionnel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var RisqueProfessionnel
     */
    public $RisqueProfessionnel;
    /**
     * Constructor method for AssureData
     * @uses AssureData::setCivilite()
     * @uses AssureData::setDateNaissance()
     * @uses AssureData::setFumeur()
     * @uses AssureData::setGaranties()
     * @uses AssureData::setOptions()
     * @uses AssureData::setPoids()
     * @uses AssureData::setProfessionID()
     * @uses AssureData::setQuotite()
     * @uses AssureData::setSurprimes()
     * @uses AssureData::setTaille()
     * @uses AssureData::setTauxCommission()
     * @uses AssureData::setNom()
     * @uses AssureData::setPrenom()
     * @uses AssureData::setTelephone()
     * @uses AssureData::setEMail()
     * @uses AssureData::setRisqueProfessionnel()
     * @param string $civilite
     * @param string $dateNaissance
     * @param bool $fumeur
     * @param ArrayOfstring $garanties
     * @param ArrayOfstring $options
     * @param int $poids
     * @param int $professionID
     * @param float $quotite
     * @param ArrayOfSurprimeData $surprimes
     * @param int $taille
     * @param float $tauxCommission
     * @param string $nom
     * @param string $prenom
     * @param string $telephone
     * @param string $eMail
     * @param RisqueProfessionnel $risqueProfessionnel
     */
    public function __construct($civilite = null, $dateNaissance = null, $fumeur = null, ArrayOfstring $garanties = null, ArrayOfstring $options = null, $poids = null, $professionID = null, $quotite = null, ArrayOfSurprimeData $surprimes = null, $taille = null, $tauxCommission = null, $nom = null, $prenom = null, $telephone = null, $eMail = null, RisqueProfessionnel $risqueProfessionnel = null)
    {
        $this
            ->setCivilite($civilite)
            ->setDateNaissance($dateNaissance)
            ->setFumeur($fumeur)
            ->setGaranties($garanties)
            ->setOptions($options)
            ->setPoids($poids)
            ->setProfessionID($professionID)
            ->setQuotite($quotite)
            ->setSurprimes($surprimes)
            ->setTaille($taille)
            ->setTauxCommission($tauxCommission)
            ->setNom($nom)
            ->setPrenom($prenom)
            ->setTelephone($telephone)
            ->setEMail($eMail)
            ->setRisqueProfessionnel($risqueProfessionnel);
    }
    /**
     * Get Civilite value
     * @return string|null
     */
    public function getCivilite()
    {
        return $this->Civilite;
    }
    /**
     * Set Civilite value
     * @uses TypeCivilite::valueIsValid()
     * @uses TypeCivilite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $civilite
     * @return AssureData
     */
    public function setCivilite($civilite = null)
    {
        // validation for constraint: enumeration
        if (!TypeCivilite::valueIsValid($civilite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class TypeCivilite', is_array($civilite) ? implode(', ', $civilite) : var_export($civilite, true), implode(', ', TypeCivilite::getValidValues())), __LINE__);
        }
        $this->Civilite = $civilite;
        return $this;
    }
    /**
     * Get DateNaissance value
     * @return string|null
     */
    public function getDateNaissance()
    {
        return $this->DateNaissance;
    }
    /**
     * Set DateNaissance value
     * @param string $dateNaissance
     * @return AssureData
     */
    public function setDateNaissance($dateNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($dateNaissance) && !is_string($dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateNaissance, true), gettype($dateNaissance)), __LINE__);
        }
        $this->DateNaissance = $dateNaissance;
        return $this;
    }
    /**
     * Get Fumeur value
     * @return bool|null
     */
    public function getFumeur()
    {
        return $this->Fumeur;
    }
    /**
     * Set Fumeur value
     * @param bool $fumeur
     * @return AssureData
     */
    public function setFumeur($fumeur = null)
    {
        // validation for constraint: boolean
        if (!is_null($fumeur) && !is_bool($fumeur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fumeur, true), gettype($fumeur)), __LINE__);
        }
        $this->Fumeur = $fumeur;
        return $this;
    }
    /**
     * Get Garanties value
     * @return ArrayOfstring|null
     */
    public function getGaranties()
    {
        return $this->Garanties;
    }
    /**
     * Set Garanties value
     * @param ArrayOfstring $garanties
     * @return AssureData
     */
    public function setGaranties(ArrayOfstring $garanties = null)
    {
        $this->Garanties = $garanties;
        return $this;
    }
    /**
     * Get Options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfstring|null
     */
    public function getOptions()
    {
        return isset($this->Options) ? $this->Options : null;
    }
    /**
     * Set Options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfstring $options
     * @return AssureData
     */
    public function setOptions(ArrayOfstring $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->Options);
        } else {
            $this->Options = $options;
        }
        return $this;
    }
    /**
     * Get Poids value
     * @return int|null
     */
    public function getPoids()
    {
        return $this->Poids;
    }
    /**
     * Set Poids value
     * @param int $poids
     * @return AssureData
     */
    public function setPoids($poids = null)
    {
        // validation for constraint: int
        if (!is_null($poids) && !(is_int($poids) || ctype_digit($poids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poids, true), gettype($poids)), __LINE__);
        }
        $this->Poids = $poids;
        return $this;
    }
    /**
     * Get ProfessionID value
     * @return int|null
     */
    public function getProfessionID()
    {
        return $this->ProfessionID;
    }
    /**
     * Set ProfessionID value
     * @param int $professionID
     * @return AssureData
     */
    public function setProfessionID($professionID = null)
    {
        // validation for constraint: int
        if (!is_null($professionID) && !(is_int($professionID) || ctype_digit($professionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($professionID, true), gettype($professionID)), __LINE__);
        }
        $this->ProfessionID = $professionID;
        return $this;
    }
    /**
     * Get Quotite value
     * @return float|null
     */
    public function getQuotite()
    {
        return $this->Quotite;
    }
    /**
     * Set Quotite value
     * @param float $quotite
     * @return AssureData
     */
    public function setQuotite($quotite = null)
    {
        // validation for constraint: float
        if (!is_null($quotite) && !(is_float($quotite) || is_numeric($quotite))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quotite, true), gettype($quotite)), __LINE__);
        }
        $this->Quotite = $quotite;
        return $this;
    }
    /**
     * Get Surprimes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfSurprimeData|null
     */
    public function getSurprimes()
    {
        return isset($this->Surprimes) ? $this->Surprimes : null;
    }
    /**
     * Set Surprimes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfSurprimeData $surprimes
     * @return AssureData
     */
    public function setSurprimes(ArrayOfSurprimeData $surprimes = null)
    {
        if (is_null($surprimes) || (is_array($surprimes) && empty($surprimes))) {
            unset($this->Surprimes);
        } else {
            $this->Surprimes = $surprimes;
        }
        return $this;
    }
    /**
     * Get Taille value
     * @return int|null
     */
    public function getTaille()
    {
        return $this->Taille;
    }
    /**
     * Set Taille value
     * @param int $taille
     * @return AssureData
     */
    public function setTaille($taille = null)
    {
        // validation for constraint: int
        if (!is_null($taille) && !(is_int($taille) || ctype_digit($taille))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taille, true), gettype($taille)), __LINE__);
        }
        $this->Taille = $taille;
        return $this;
    }
    /**
     * Get TauxCommission value
     * @return float|null
     */
    public function getTauxCommission()
    {
        return $this->TauxCommission;
    }
    /**
     * Set TauxCommission value
     * @param float $tauxCommission
     * @return AssureData
     */
    public function setTauxCommission($tauxCommission = null)
    {
        // validation for constraint: float
        if (!is_null($tauxCommission) && !(is_float($tauxCommission) || is_numeric($tauxCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tauxCommission, true), gettype($tauxCommission)), __LINE__);
        }
        $this->TauxCommission = $tauxCommission;
        return $this;
    }
    /**
     * Get Nom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom()
    {
        return isset($this->Nom) ? $this->Nom : null;
    }
    /**
     * Set Nom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom
     * @return AssureData
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        if (is_null($nom) || (is_array($nom) && empty($nom))) {
            unset($this->Nom);
        } else {
            $this->Nom = $nom;
        }
        return $this;
    }
    /**
     * Get Prenom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrenom()
    {
        return isset($this->Prenom) ? $this->Prenom : null;
    }
    /**
     * Set Prenom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prenom
     * @return AssureData
     */
    public function setPrenom($prenom = null)
    {
        // validation for constraint: string
        if (!is_null($prenom) && !is_string($prenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prenom, true), gettype($prenom)), __LINE__);
        }
        if (is_null($prenom) || (is_array($prenom) && empty($prenom))) {
            unset($this->Prenom);
        } else {
            $this->Prenom = $prenom;
        }
        return $this;
    }
    /**
     * Get Telephone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephone()
    {
        return isset($this->Telephone) ? $this->Telephone : null;
    }
    /**
     * Set Telephone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephone
     * @return AssureData
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        if (is_null($telephone) || (is_array($telephone) && empty($telephone))) {
            unset($this->Telephone);
        } else {
            $this->Telephone = $telephone;
        }
        return $this;
    }
    /**
     * Get EMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEMail()
    {
        return isset($this->EMail) ? $this->EMail : null;
    }
    /**
     * Set EMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eMail
     * @return AssureData
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        if (is_null($eMail) || (is_array($eMail) && empty($eMail))) {
            unset($this->EMail);
        } else {
            $this->EMail = $eMail;
        }
        return $this;
    }
    /**
     * Get RisqueProfessionnel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return RisqueProfessionnel|null
     */
    public function getRisqueProfessionnel()
    {
        return isset($this->RisqueProfessionnel) ? $this->RisqueProfessionnel : null;
    }
    /**
     * Set RisqueProfessionnel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param RisqueProfessionnel $risqueProfessionnel
     * @return AssureData
     */
    public function setRisqueProfessionnel(RisqueProfessionnel $risqueProfessionnel = null)
    {
        if (is_null($risqueProfessionnel) || (is_array($risqueProfessionnel) && empty($risqueProfessionnel))) {
            unset($this->RisqueProfessionnel);
        } else {
            $this->RisqueProfessionnel = $risqueProfessionnel;
        }
        return $this;
    }
}
