<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPretData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPretData
 * @subpackage Arrays
 */
class ArrayOfPretData extends AbstractStructArrayBase
{
    /**
     * The PretData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var PretData[]
     */
    public $PretData;
    /**
     * Constructor method for ArrayOfPretData
     * @uses ArrayOfPretData::setPretData()
     * @param PretData[] $pretData
     */
    public function __construct(array $pretData = array())
    {
        $this
            ->setPretData($pretData);
    }
    /**
     * Get PretData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return PretData[]|null
     */
    public function getPretData()
    {
        return isset($this->PretData) ? $this->PretData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPretData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPretData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePretDataForArrayConstraintsFromSetPretData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPretDataPretDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPretDataPretDataItem instanceof PretData) {
                $invalidValues[] = is_object($arrayOfPretDataPretDataItem) ? get_class($arrayOfPretDataPretDataItem) : sprintf('%s(%s)', gettype($arrayOfPretDataPretDataItem), var_export($arrayOfPretDataPretDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PretData property can only contain items of type PretData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PretData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param PretData[] $pretData
     * @return ArrayOfPretData
     */
    public function setPretData(array $pretData = array())
    {
        // validation for constraint: array
        if ('' !== ($pretDataArrayErrorMessage = self::validatePretDataForArrayConstraintsFromSetPretData($pretData))) {
            throw new \InvalidArgumentException($pretDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pretData) || (is_array($pretData) && empty($pretData))) {
            unset($this->PretData);
        } else {
            $this->PretData = $pretData;
        }
        return $this;
    }
    /**
     * Add item to PretData value
     * @throws \InvalidArgumentException
     * @param PretData $item
     * @return ArrayOfPretData
     */
    public function addToPretData(PretData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PretData) {
            throw new \InvalidArgumentException(sprintf('The PretData property can only contain items of type PretData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PretData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return PretData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return PretData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return PretData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return PretData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return PretData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PretData
     */
    public function getAttributeName()
    {
        return 'PretData';
    }
}
