<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wsnfdgr.portalfiat.com.br/WSOSService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wsnfdgr.portalfiat.com.br/WSOSService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Abrir ServiceType
 */
$abrir = new \ServiceType\Abrir($options);
/**
 * Sample call for AbrirOrdemServico operation/method
 */
if ($abrir->AbrirOrdemServico(new \StructType\AbrirOrdemServico()) !== false) {
    print_r($abrir->getResult());
} else {
    print_r($abrir->getLastError());
}
/**
 * Samples for Fechar ServiceType
 */
$fechar = new \ServiceType\Fechar($options);
/**
 * Sample call for FecharOrdemServico operation/method
 */
if ($fechar->FecharOrdemServico(new \StructType\FecharOrdemServico()) !== false) {
    print_r($fechar->getResult());
} else {
    print_r($fechar->getLastError());
}
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
/**
 * Sample call for CancelarOrdemServico operation/method
 */
if ($cancelar->CancelarOrdemServico(new \StructType\CancelarOrdemServico()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
