<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelarOrdemServico StructType
 * @subpackage Structs
 */
class CancelarOrdemServico extends AbstractStructBase
{
    /**
     * The concessionaria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $concessionaria;
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $cnpj;
    /**
     * The numOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numOS;
    /**
     * The versaoDMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $versaoDMS;
    /**
     * The versaoSoft
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $versaoSoft;
    /**
     * Constructor method for CancelarOrdemServico
     * @uses CancelarOrdemServico::setConcessionaria()
     * @uses CancelarOrdemServico::setCnpj()
     * @uses CancelarOrdemServico::setNumOS()
     * @uses CancelarOrdemServico::setVersaoDMS()
     * @uses CancelarOrdemServico::setVersaoSoft()
     * @param int $concessionaria
     * @param int $cnpj
     * @param string $numOS
     * @param string $versaoDMS
     * @param string $versaoSoft
     */
    public function __construct($concessionaria = null, $cnpj = null, $numOS = null, $versaoDMS = null, $versaoSoft = null)
    {
        $this
            ->setConcessionaria($concessionaria)
            ->setCnpj($cnpj)
            ->setNumOS($numOS)
            ->setVersaoDMS($versaoDMS)
            ->setVersaoSoft($versaoSoft);
    }
    /**
     * Get concessionaria value
     * @return int
     */
    public function getConcessionaria()
    {
        return $this->concessionaria;
    }
    /**
     * Set concessionaria value
     * @param int $concessionaria
     * @return \StructType\CancelarOrdemServico
     */
    public function setConcessionaria($concessionaria = null)
    {
        // validation for constraint: int
        if (!is_null($concessionaria) && !(is_int($concessionaria) || ctype_digit($concessionaria))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($concessionaria, true), gettype($concessionaria)), __LINE__);
        }
        $this->concessionaria = $concessionaria;
        return $this;
    }
    /**
     * Get cnpj value
     * @return int
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param int $cnpj
     * @return \StructType\CancelarOrdemServico
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: int
        if (!is_null($cnpj) && !(is_int($cnpj) || ctype_digit($cnpj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get numOS value
     * @return string|null
     */
    public function getNumOS()
    {
        return $this->numOS;
    }
    /**
     * Set numOS value
     * @param string $numOS
     * @return \StructType\CancelarOrdemServico
     */
    public function setNumOS($numOS = null)
    {
        // validation for constraint: string
        if (!is_null($numOS) && !is_string($numOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOS, true), gettype($numOS)), __LINE__);
        }
        $this->numOS = $numOS;
        return $this;
    }
    /**
     * Get versaoDMS value
     * @return string|null
     */
    public function getVersaoDMS()
    {
        return $this->versaoDMS;
    }
    /**
     * Set versaoDMS value
     * @param string $versaoDMS
     * @return \StructType\CancelarOrdemServico
     */
    public function setVersaoDMS($versaoDMS = null)
    {
        // validation for constraint: string
        if (!is_null($versaoDMS) && !is_string($versaoDMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versaoDMS, true), gettype($versaoDMS)), __LINE__);
        }
        $this->versaoDMS = $versaoDMS;
        return $this;
    }
    /**
     * Get versaoSoft value
     * @return string|null
     */
    public function getVersaoSoft()
    {
        return $this->versaoSoft;
    }
    /**
     * Set versaoSoft value
     * @param string $versaoSoft
     * @return \StructType\CancelarOrdemServico
     */
    public function setVersaoSoft($versaoSoft = null)
    {
        // validation for constraint: string
        if (!is_null($versaoSoft) && !is_string($versaoSoft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versaoSoft, true), gettype($versaoSoft)), __LINE__);
        }
        $this->versaoSoft = $versaoSoft;
        return $this;
    }
}
