<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wsnfdgr.portalfiat.com.br/nf_pecas.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://wsnfdgr.portalfiat.com.br/nf_pecas.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Execute ServiceType
 */
$execute = new \ServiceType\Execute($options);
/**
 * Sample call for Execute operation/method
 */
if ($execute->Execute(new \StructType\Execute()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Sample call for execute_1 operation/method
 */
if ($execute->execute_1(new \StructType\Execute_1()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for EnviarNF_1 operation/method
 */
if ($enviar->EnviarNF_1(new \StructType\EnviarNF_1()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
