<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteResponse StructType
 * @subpackage Structs
 */
class ExecuteResponse extends AbstractStructBase
{
    /**
     * The protocolo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $protocolo;
    /**
     * The ExecuteResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExecuteResult;
    /**
     * Constructor method for ExecuteResponse
     * @uses ExecuteResponse::setProtocolo()
     * @uses ExecuteResponse::setExecuteResult()
     * @param int $protocolo
     * @param string $executeResult
     */
    public function __construct($protocolo = null, $executeResult = null)
    {
        $this
            ->setProtocolo($protocolo)
            ->setExecuteResult($executeResult);
    }
    /**
     * Get protocolo value
     * @return int
     */
    public function getProtocolo()
    {
        return $this->protocolo;
    }
    /**
     * Set protocolo value
     * @param int $protocolo
     * @return \StructType\ExecuteResponse
     */
    public function setProtocolo($protocolo = null)
    {
        // validation for constraint: int
        if (!is_null($protocolo) && !(is_int($protocolo) || ctype_digit($protocolo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($protocolo, true), gettype($protocolo)), __LINE__);
        }
        $this->protocolo = $protocolo;
        return $this;
    }
    /**
     * Get ExecuteResult value
     * @return string|null
     */
    public function getExecuteResult()
    {
        return $this->ExecuteResult;
    }
    /**
     * Set ExecuteResult value
     * @param string $executeResult
     * @return \StructType\ExecuteResponse
     */
    public function setExecuteResult($executeResult = null)
    {
        // validation for constraint: string
        if (!is_null($executeResult) && !is_string($executeResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executeResult, true), gettype($executeResult)), __LINE__);
        }
        $this->ExecuteResult = $executeResult;
        return $this;
    }
}
