<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for execute StructType
 * @subpackage Structs
 */
class Execute_1 extends AbstractStructBase
{
    /**
     * The numOs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numOs;
    /**
     * The simplesRemessa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $simplesRemessa;
    /**
     * The arqXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arqXml;
    /**
     * The numMVP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numMVP;
    /**
     * Constructor method for execute
     * @uses Execute_1::setNumOs()
     * @uses Execute_1::setSimplesRemessa()
     * @uses Execute_1::setArqXml()
     * @uses Execute_1::setNumMVP()
     * @param int $numOs
     * @param int $simplesRemessa
     * @param string $arqXml
     * @param string $numMVP
     */
    public function __construct($numOs = null, $simplesRemessa = null, $arqXml = null, $numMVP = null)
    {
        $this
            ->setNumOs($numOs)
            ->setSimplesRemessa($simplesRemessa)
            ->setArqXml($arqXml)
            ->setNumMVP($numMVP);
    }
    /**
     * Get numOs value
     * @return int
     */
    public function getNumOs()
    {
        return $this->numOs;
    }
    /**
     * Set numOs value
     * @param int $numOs
     * @return \StructType\Execute_1
     */
    public function setNumOs($numOs = null)
    {
        // validation for constraint: int
        if (!is_null($numOs) && !(is_int($numOs) || ctype_digit($numOs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOs, true), gettype($numOs)), __LINE__);
        }
        $this->numOs = $numOs;
        return $this;
    }
    /**
     * Get simplesRemessa value
     * @return int
     */
    public function getSimplesRemessa()
    {
        return $this->simplesRemessa;
    }
    /**
     * Set simplesRemessa value
     * @param int $simplesRemessa
     * @return \StructType\Execute_1
     */
    public function setSimplesRemessa($simplesRemessa = null)
    {
        // validation for constraint: int
        if (!is_null($simplesRemessa) && !(is_int($simplesRemessa) || ctype_digit($simplesRemessa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($simplesRemessa, true), gettype($simplesRemessa)), __LINE__);
        }
        $this->simplesRemessa = $simplesRemessa;
        return $this;
    }
    /**
     * Get arqXml value
     * @return string|null
     */
    public function getArqXml()
    {
        return $this->arqXml;
    }
    /**
     * Set arqXml value
     * @param string $arqXml
     * @return \StructType\Execute_1
     */
    public function setArqXml($arqXml = null)
    {
        // validation for constraint: string
        if (!is_null($arqXml) && !is_string($arqXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arqXml, true), gettype($arqXml)), __LINE__);
        }
        $this->arqXml = $arqXml;
        return $this;
    }
    /**
     * Get numMVP value
     * @return string|null
     */
    public function getNumMVP()
    {
        return $this->numMVP;
    }
    /**
     * Set numMVP value
     * @param string $numMVP
     * @return \StructType\Execute_1
     */
    public function setNumMVP($numMVP = null)
    {
        // validation for constraint: string
        if (!is_null($numMVP) && !is_string($numMVP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numMVP, true), gettype($numMVP)), __LINE__);
        }
        $this->numMVP = $numMVP;
        return $this;
    }
}
