<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Execute StructType
 * @subpackage Structs
 */
class Execute extends AbstractStructBase
{
    /**
     * The numOs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numOs;
    /**
     * The arqXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arqXml;
    /**
     * The numMVP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numMVP;
    /**
     * Constructor method for Execute
     * @uses Execute::setNumOs()
     * @uses Execute::setArqXml()
     * @uses Execute::setNumMVP()
     * @param int $numOs
     * @param string $arqXml
     * @param string $numMVP
     */
    public function __construct($numOs = null, $arqXml = null, $numMVP = null)
    {
        $this
            ->setNumOs($numOs)
            ->setArqXml($arqXml)
            ->setNumMVP($numMVP);
    }
    /**
     * Get numOs value
     * @return int
     */
    public function getNumOs()
    {
        return $this->numOs;
    }
    /**
     * Set numOs value
     * @param int $numOs
     * @return \StructType\Execute
     */
    public function setNumOs($numOs = null)
    {
        // validation for constraint: int
        if (!is_null($numOs) && !(is_int($numOs) || ctype_digit($numOs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOs, true), gettype($numOs)), __LINE__);
        }
        $this->numOs = $numOs;
        return $this;
    }
    /**
     * Get arqXml value
     * @return string|null
     */
    public function getArqXml()
    {
        return $this->arqXml;
    }
    /**
     * Set arqXml value
     * @param string $arqXml
     * @return \StructType\Execute
     */
    public function setArqXml($arqXml = null)
    {
        // validation for constraint: string
        if (!is_null($arqXml) && !is_string($arqXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arqXml, true), gettype($arqXml)), __LINE__);
        }
        $this->arqXml = $arqXml;
        return $this;
    }
    /**
     * Get numMVP value
     * @return string|null
     */
    public function getNumMVP()
    {
        return $this->numMVP;
    }
    /**
     * Set numMVP value
     * @param string $numMVP
     * @return \StructType\Execute
     */
    public function setNumMVP($numMVP = null)
    {
        // validation for constraint: string
        if (!is_null($numMVP) && !is_string($numMVP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numMVP, true), gettype($numMVP)), __LINE__);
        }
        $this->numMVP = $numMVP;
        return $this;
    }
}
