<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepositorySearch StructType
 * @subpackage Structs
 */
class RepositorySearch extends SearchRequestType
{
    /**
     * The SearchScope
     * @var \StructType\SearchScopeType
     */
    public $SearchScope;
    /**
     * The SearchSQL
     * @var string
     */
    public $SearchSQL;
    /**
     * The repositorySearchMode
     * @var string
     */
    public $repositorySearchMode;
    /**
     * Constructor method for RepositorySearch
     * @uses RepositorySearch::setSearchScope()
     * @uses RepositorySearch::setSearchSQL()
     * @uses RepositorySearch::setRepositorySearchMode()
     * @param \StructType\SearchScopeType $searchScope
     * @param string $searchSQL
     * @param string $repositorySearchMode
     */
    public function __construct(\StructType\SearchScopeType $searchScope = null, $searchSQL = null, $repositorySearchMode = null)
    {
        $this
            ->setSearchScope($searchScope)
            ->setSearchSQL($searchSQL)
            ->setRepositorySearchMode($repositorySearchMode);
    }
    /**
     * Get SearchScope value
     * @return \StructType\SearchScopeType|null
     */
    public function getSearchScope()
    {
        return $this->SearchScope;
    }
    /**
     * Set SearchScope value
     * @param \StructType\SearchScopeType $searchScope
     * @return \StructType\RepositorySearch
     */
    public function setSearchScope(\StructType\SearchScopeType $searchScope = null)
    {
        $this->SearchScope = $searchScope;
        return $this;
    }
    /**
     * Get SearchSQL value
     * @return string|null
     */
    public function getSearchSQL()
    {
        return $this->SearchSQL;
    }
    /**
     * Set SearchSQL value
     * @param string $searchSQL
     * @return \StructType\RepositorySearch
     */
    public function setSearchSQL($searchSQL = null)
    {
        // validation for constraint: string
        if (!is_null($searchSQL) && !is_string($searchSQL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchSQL, true), gettype($searchSQL)), __LINE__);
        }
        $this->SearchSQL = $searchSQL;
        return $this;
    }
    /**
     * Get repositorySearchMode value
     * @return string|null
     */
    public function getRepositorySearchMode()
    {
        return $this->repositorySearchMode;
    }
    /**
     * Set repositorySearchMode value
     * @uses \EnumType\RepositorySearchModeType::valueIsValid()
     * @uses \EnumType\RepositorySearchModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repositorySearchMode
     * @return \StructType\RepositorySearch
     */
    public function setRepositorySearchMode($repositorySearchMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RepositorySearchModeType::valueIsValid($repositorySearchMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RepositorySearchModeType', is_array($repositorySearchMode) ? implode(', ', $repositorySearchMode) : var_export($repositorySearchMode, true), implode(', ', \EnumType\RepositorySearchModeType::getValidValues())), __LINE__);
        }
        $this->repositorySearchMode = $repositorySearchMode;
        return $this;
    }
}
