<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RaiseEventAction StructType
 * @subpackage Structs
 */
class RaiseEventAction extends ActionType
{
    /**
     * The classId
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $classId;
    /**
     * The EventProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ModifiedPropertiesType
     */
    public $EventProperties;
    /**
     * Constructor method for RaiseEventAction
     * @uses RaiseEventAction::setClassId()
     * @uses RaiseEventAction::setEventProperties()
     * @param string $classId
     * @param \StructType\ModifiedPropertiesType $eventProperties
     */
    public function __construct($classId = null, \StructType\ModifiedPropertiesType $eventProperties = null)
    {
        $this
            ->setClassId($classId)
            ->setEventProperties($eventProperties);
    }
    /**
     * Get classId value
     * @return string
     */
    public function getClassId()
    {
        return $this->classId;
    }
    /**
     * Set classId value
     * @param string $classId
     * @return \StructType\RaiseEventAction
     */
    public function setClassId($classId = null)
    {
        // validation for constraint: string
        if (!is_null($classId) && !is_string($classId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classId, true), gettype($classId)), __LINE__);
        }
        $this->classId = $classId;
        return $this;
    }
    /**
     * Get EventProperties value
     * @return \StructType\ModifiedPropertiesType|null
     */
    public function getEventProperties()
    {
        return $this->EventProperties;
    }
    /**
     * Set EventProperties value
     * @param \StructType\ModifiedPropertiesType $eventProperties
     * @return \StructType\RaiseEventAction
     */
    public function setEventProperties(\StructType\ModifiedPropertiesType $eventProperties = null)
    {
        $this->EventProperties = $eventProperties;
        return $this;
    }
}
