<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyType StructType
 * @subpackage Structs
 */
abstract class PropertyType extends AbstractStructBase
{
    /**
     * The propertyId
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $propertyId;
    /**
     * The settable
     * @var bool
     */
    public $settable;
    /**
     * Constructor method for PropertyType
     * @uses PropertyType::setPropertyId()
     * @uses PropertyType::setSettable()
     * @param string $propertyId
     * @param bool $settable
     */
    public function __construct($propertyId = null, $settable = null)
    {
        $this
            ->setPropertyId($propertyId)
            ->setSettable($settable);
    }
    /**
     * Get propertyId value
     * @return string
     */
    public function getPropertyId()
    {
        return $this->propertyId;
    }
    /**
     * Set propertyId value
     * @param string $propertyId
     * @return \StructType\PropertyType
     */
    public function setPropertyId($propertyId = null)
    {
        // validation for constraint: string
        if (!is_null($propertyId) && !is_string($propertyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyId, true), gettype($propertyId)), __LINE__);
        }
        $this->propertyId = $propertyId;
        return $this;
    }
    /**
     * Get settable value
     * @return bool|null
     */
    public function getSettable()
    {
        return $this->settable;
    }
    /**
     * Set settable value
     * @param bool $settable
     * @return \StructType\PropertyType
     */
    public function setSettable($settable = null)
    {
        // validation for constraint: boolean
        if (!is_null($settable) && !is_bool($settable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($settable, true), gettype($settable)), __LINE__);
        }
        $this->settable = $settable;
        return $this;
    }
}
