<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyFilterType StructType
 * @subpackage Structs
 */
class PropertyFilterType extends AbstractStructBase
{
    /**
     * The IncludeProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FilterElementType[]
     */
    public $IncludeProperties;
    /**
     * The IncludeTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FilterElementType[]
     */
    public $IncludeTypes;
    /**
     * The ExcludeProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ExcludeProperties;
    /**
     * The maxRecursion
     * @var int
     */
    public $maxRecursion;
    /**
     * The maxSize
     * @var int
     */
    public $maxSize;
    /**
     * The maxElements
     * @var int
     */
    public $maxElements;
    /**
     * The levelDependents
     * @var bool
     */
    public $levelDependents;
    /**
     * Constructor method for PropertyFilterType
     * @uses PropertyFilterType::setIncludeProperties()
     * @uses PropertyFilterType::setIncludeTypes()
     * @uses PropertyFilterType::setExcludeProperties()
     * @uses PropertyFilterType::setMaxRecursion()
     * @uses PropertyFilterType::setMaxSize()
     * @uses PropertyFilterType::setMaxElements()
     * @uses PropertyFilterType::setLevelDependents()
     * @param \StructType\FilterElementType[] $includeProperties
     * @param \StructType\FilterElementType[] $includeTypes
     * @param string[] $excludeProperties
     * @param int $maxRecursion
     * @param int $maxSize
     * @param int $maxElements
     * @param bool $levelDependents
     */
    public function __construct(array $includeProperties = array(), array $includeTypes = array(), array $excludeProperties = array(), $maxRecursion = null, $maxSize = null, $maxElements = null, $levelDependents = null)
    {
        $this
            ->setIncludeProperties($includeProperties)
            ->setIncludeTypes($includeTypes)
            ->setExcludeProperties($excludeProperties)
            ->setMaxRecursion($maxRecursion)
            ->setMaxSize($maxSize)
            ->setMaxElements($maxElements)
            ->setLevelDependents($levelDependents);
    }
    /**
     * Get IncludeProperties value
     * @return \StructType\FilterElementType[]|null
     */
    public function getIncludeProperties()
    {
        return $this->IncludeProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setIncludeProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncludeProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncludePropertiesForArrayConstraintsFromSetIncludeProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyFilterTypeIncludePropertiesItem) {
            // validation for constraint: itemType
            if (!$propertyFilterTypeIncludePropertiesItem instanceof \StructType\FilterElementType) {
                $invalidValues[] = is_object($propertyFilterTypeIncludePropertiesItem) ? get_class($propertyFilterTypeIncludePropertiesItem) : sprintf('%s(%s)', gettype($propertyFilterTypeIncludePropertiesItem), var_export($propertyFilterTypeIncludePropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IncludeProperties property can only contain items of type \StructType\FilterElementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IncludeProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterElementType[] $includeProperties
     * @return \StructType\PropertyFilterType
     */
    public function setIncludeProperties(array $includeProperties = array())
    {
        // validation for constraint: array
        if ('' !== ($includePropertiesArrayErrorMessage = self::validateIncludePropertiesForArrayConstraintsFromSetIncludeProperties($includeProperties))) {
            throw new \InvalidArgumentException($includePropertiesArrayErrorMessage, __LINE__);
        }
        $this->IncludeProperties = $includeProperties;
        return $this;
    }
    /**
     * Add item to IncludeProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterElementType $item
     * @return \StructType\PropertyFilterType
     */
    public function addToIncludeProperties(\StructType\FilterElementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterElementType) {
            throw new \InvalidArgumentException(sprintf('The IncludeProperties property can only contain items of type \StructType\FilterElementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IncludeProperties[] = $item;
        return $this;
    }
    /**
     * Get IncludeTypes value
     * @return \StructType\FilterElementType[]|null
     */
    public function getIncludeTypes()
    {
        return $this->IncludeTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setIncludeTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncludeTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncludeTypesForArrayConstraintsFromSetIncludeTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyFilterTypeIncludeTypesItem) {
            // validation for constraint: itemType
            if (!$propertyFilterTypeIncludeTypesItem instanceof \StructType\FilterElementType) {
                $invalidValues[] = is_object($propertyFilterTypeIncludeTypesItem) ? get_class($propertyFilterTypeIncludeTypesItem) : sprintf('%s(%s)', gettype($propertyFilterTypeIncludeTypesItem), var_export($propertyFilterTypeIncludeTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IncludeTypes property can only contain items of type \StructType\FilterElementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IncludeTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterElementType[] $includeTypes
     * @return \StructType\PropertyFilterType
     */
    public function setIncludeTypes(array $includeTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($includeTypesArrayErrorMessage = self::validateIncludeTypesForArrayConstraintsFromSetIncludeTypes($includeTypes))) {
            throw new \InvalidArgumentException($includeTypesArrayErrorMessage, __LINE__);
        }
        $this->IncludeTypes = $includeTypes;
        return $this;
    }
    /**
     * Add item to IncludeTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterElementType $item
     * @return \StructType\PropertyFilterType
     */
    public function addToIncludeTypes(\StructType\FilterElementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterElementType) {
            throw new \InvalidArgumentException(sprintf('The IncludeTypes property can only contain items of type \StructType\FilterElementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IncludeTypes[] = $item;
        return $this;
    }
    /**
     * Get ExcludeProperties value
     * @return string[]|null
     */
    public function getExcludeProperties()
    {
        return $this->ExcludeProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setExcludeProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExcludeProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExcludePropertiesForArrayConstraintsFromSetExcludeProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyFilterTypeExcludePropertiesItem) {
            // validation for constraint: itemType
            if (!is_string($propertyFilterTypeExcludePropertiesItem)) {
                $invalidValues[] = is_object($propertyFilterTypeExcludePropertiesItem) ? get_class($propertyFilterTypeExcludePropertiesItem) : sprintf('%s(%s)', gettype($propertyFilterTypeExcludePropertiesItem), var_export($propertyFilterTypeExcludePropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExcludeProperties property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExcludeProperties value
     * @throws \InvalidArgumentException
     * @param string[] $excludeProperties
     * @return \StructType\PropertyFilterType
     */
    public function setExcludeProperties(array $excludeProperties = array())
    {
        // validation for constraint: array
        if ('' !== ($excludePropertiesArrayErrorMessage = self::validateExcludePropertiesForArrayConstraintsFromSetExcludeProperties($excludeProperties))) {
            throw new \InvalidArgumentException($excludePropertiesArrayErrorMessage, __LINE__);
        }
        $this->ExcludeProperties = $excludeProperties;
        return $this;
    }
    /**
     * Add item to ExcludeProperties value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PropertyFilterType
     */
    public function addToExcludeProperties($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ExcludeProperties property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExcludeProperties[] = $item;
        return $this;
    }
    /**
     * Get maxRecursion value
     * @return int|null
     */
    public function getMaxRecursion()
    {
        return $this->maxRecursion;
    }
    /**
     * Set maxRecursion value
     * @param int $maxRecursion
     * @return \StructType\PropertyFilterType
     */
    public function setMaxRecursion($maxRecursion = null)
    {
        // validation for constraint: int
        if (!is_null($maxRecursion) && !(is_int($maxRecursion) || ctype_digit($maxRecursion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRecursion, true), gettype($maxRecursion)), __LINE__);
        }
        $this->maxRecursion = $maxRecursion;
        return $this;
    }
    /**
     * Get maxSize value
     * @return int|null
     */
    public function getMaxSize()
    {
        return $this->maxSize;
    }
    /**
     * Set maxSize value
     * @param int $maxSize
     * @return \StructType\PropertyFilterType
     */
    public function setMaxSize($maxSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxSize) && !(is_int($maxSize) || ctype_digit($maxSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSize, true), gettype($maxSize)), __LINE__);
        }
        $this->maxSize = $maxSize;
        return $this;
    }
    /**
     * Get maxElements value
     * @return int|null
     */
    public function getMaxElements()
    {
        return $this->maxElements;
    }
    /**
     * Set maxElements value
     * @param int $maxElements
     * @return \StructType\PropertyFilterType
     */
    public function setMaxElements($maxElements = null)
    {
        // validation for constraint: int
        if (!is_null($maxElements) && !(is_int($maxElements) || ctype_digit($maxElements))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxElements, true), gettype($maxElements)), __LINE__);
        }
        $this->maxElements = $maxElements;
        return $this;
    }
    /**
     * Get levelDependents value
     * @return bool|null
     */
    public function getLevelDependents()
    {
        return $this->levelDependents;
    }
    /**
     * Set levelDependents value
     * @param bool $levelDependents
     * @return \StructType\PropertyFilterType
     */
    public function setLevelDependents($levelDependents = null)
    {
        // validation for constraint: boolean
        if (!is_null($levelDependents) && !is_bool($levelDependents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($levelDependents, true), gettype($levelDependents)), __LINE__);
        }
        $this->levelDependents = $levelDependents;
        return $this;
    }
}
