<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectStoreScope StructType
 * @subpackage Structs
 */
class ObjectStoreScope extends SearchScopeType
{
    /**
     * The objectStore
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $objectStore;
    /**
     * Constructor method for ObjectStoreScope
     * @uses ObjectStoreScope::setObjectStore()
     * @param string $objectStore
     */
    public function __construct($objectStore = null)
    {
        $this
            ->setObjectStore($objectStore);
    }
    /**
     * Get objectStore value
     * @return string
     */
    public function getObjectStore()
    {
        return $this->objectStore;
    }
    /**
     * Set objectStore value
     * @param string $objectStore
     * @return \StructType\ObjectStoreScope
     */
    public function setObjectStore($objectStore = null)
    {
        // validation for constraint: string
        if (!is_null($objectStore) && !is_string($objectStore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectStore, true), gettype($objectStore)), __LINE__);
        }
        $this->objectStore = $objectStore;
        return $this;
    }
}
