<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LockAction StructType
 * @subpackage Structs
 */
class LockAction extends ActionType
{
    /**
     * The timeout
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $timeout;
    /**
     * The owner
     * @var string
     */
    public $owner;
    /**
     * Constructor method for LockAction
     * @uses LockAction::setTimeout()
     * @uses LockAction::setOwner()
     * @param int $timeout
     * @param string $owner
     */
    public function __construct($timeout = null, $owner = null)
    {
        $this
            ->setTimeout($timeout)
            ->setOwner($owner);
    }
    /**
     * Get timeout value
     * @return int
     */
    public function getTimeout()
    {
        return $this->timeout;
    }
    /**
     * Set timeout value
     * @param int $timeout
     * @return \StructType\LockAction
     */
    public function setTimeout($timeout = null)
    {
        // validation for constraint: int
        if (!is_null($timeout) && !(is_int($timeout) || ctype_digit($timeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeout, true), gettype($timeout)), __LINE__);
        }
        $this->timeout = $timeout;
        return $this;
    }
    /**
     * Get owner value
     * @return string|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param string $owner
     * @return \StructType\LockAction
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
}
