<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteChangesRequest StructType
 * @subpackage Structs
 */
class ExecuteChangesRequest extends AbstractStructBase
{
    /**
     * The ChangeRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRequestType[]
     */
    public $ChangeRequest;
    /**
     * The refresh
     * @var bool
     */
    public $refresh;
    /**
     * Constructor method for ExecuteChangesRequest
     * @uses ExecuteChangesRequest::setChangeRequest()
     * @uses ExecuteChangesRequest::setRefresh()
     * @param \StructType\ChangeRequestType[] $changeRequest
     * @param bool $refresh
     */
    public function __construct(array $changeRequest = array(), $refresh = null)
    {
        $this
            ->setChangeRequest($changeRequest)
            ->setRefresh($refresh);
    }
    /**
     * Get ChangeRequest value
     * @return \StructType\ChangeRequestType[]|null
     */
    public function getChangeRequest()
    {
        return $this->ChangeRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRequestForArrayConstraintsFromSetChangeRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $executeChangesRequestChangeRequestItem) {
            // validation for constraint: itemType
            if (!$executeChangesRequestChangeRequestItem instanceof \StructType\ChangeRequestType) {
                $invalidValues[] = is_object($executeChangesRequestChangeRequestItem) ? get_class($executeChangesRequestChangeRequestItem) : sprintf('%s(%s)', gettype($executeChangesRequestChangeRequestItem), var_export($executeChangesRequestChangeRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRequest property can only contain items of type \StructType\ChangeRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRequestType[] $changeRequest
     * @return \StructType\ExecuteChangesRequest
     */
    public function setChangeRequest(array $changeRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRequestArrayErrorMessage = self::validateChangeRequestForArrayConstraintsFromSetChangeRequest($changeRequest))) {
            throw new \InvalidArgumentException($changeRequestArrayErrorMessage, __LINE__);
        }
        $this->ChangeRequest = $changeRequest;
        return $this;
    }
    /**
     * Add item to ChangeRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRequestType $item
     * @return \StructType\ExecuteChangesRequest
     */
    public function addToChangeRequest(\StructType\ChangeRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRequestType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRequest property can only contain items of type \StructType\ChangeRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRequest[] = $item;
        return $this;
    }
    /**
     * Get refresh value
     * @return bool|null
     */
    public function getRefresh()
    {
        return $this->refresh;
    }
    /**
     * Set refresh value
     * @param bool $refresh
     * @return \StructType\ExecuteChangesRequest
     */
    public function setRefresh($refresh = null)
    {
        // validation for constraint: boolean
        if (!is_null($refresh) && !is_bool($refresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refresh, true), gettype($refresh)), __LINE__);
        }
        $this->refresh = $refresh;
        return $this;
    }
}
