<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnumOfObject StructType
 * @subpackage Structs
 */
class EnumOfObject extends PropertyType
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ObjectValue[]
     */
    public $Value;
    /**
     * The CollectionTerminator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CollectionTerminatorType
     */
    public $CollectionTerminator;
    /**
     * The ParentReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ObjectReference
     */
    public $ParentReference;
    /**
     * Constructor method for EnumOfObject
     * @uses EnumOfObject::setValue()
     * @uses EnumOfObject::setCollectionTerminator()
     * @uses EnumOfObject::setParentReference()
     * @param \StructType\ObjectValue[] $value
     * @param \StructType\CollectionTerminatorType $collectionTerminator
     * @param \StructType\ObjectReference $parentReference
     */
    public function __construct(array $value = array(), \StructType\CollectionTerminatorType $collectionTerminator = null, \StructType\ObjectReference $parentReference = null)
    {
        $this
            ->setValue($value)
            ->setCollectionTerminator($collectionTerminator)
            ->setParentReference($parentReference);
    }
    /**
     * Get Value value
     * @return \StructType\ObjectValue[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enumOfObjectValueItem) {
            // validation for constraint: itemType
            if (!$enumOfObjectValueItem instanceof \StructType\ObjectValue) {
                $invalidValues[] = is_object($enumOfObjectValueItem) ? get_class($enumOfObjectValueItem) : sprintf('%s(%s)', gettype($enumOfObjectValueItem), var_export($enumOfObjectValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \StructType\ObjectValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectValue[] $value
     * @return \StructType\EnumOfObject
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectValue $item
     * @return \StructType\EnumOfObject
     */
    public function addToValue(\StructType\ObjectValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ObjectValue) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type \StructType\ObjectValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Get CollectionTerminator value
     * @return \StructType\CollectionTerminatorType|null
     */
    public function getCollectionTerminator()
    {
        return $this->CollectionTerminator;
    }
    /**
     * Set CollectionTerminator value
     * @param \StructType\CollectionTerminatorType $collectionTerminator
     * @return \StructType\EnumOfObject
     */
    public function setCollectionTerminator(\StructType\CollectionTerminatorType $collectionTerminator = null)
    {
        $this->CollectionTerminator = $collectionTerminator;
        return $this;
    }
    /**
     * Get ParentReference value
     * @return \StructType\ObjectReference|null
     */
    public function getParentReference()
    {
        return $this->ParentReference;
    }
    /**
     * Set ParentReference value
     * @param \StructType\ObjectReference $parentReference
     * @return \StructType\EnumOfObject
     */
    public function setParentReference(\StructType\ObjectReference $parentReference = null)
    {
        $this->ParentReference = $parentReference;
        return $this;
    }
}
