<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndOfPage StructType
 * @subpackage Structs
 */
class EndOfPage extends CollectionTerminatorType
{
    /**
     * The continueFrom
     * @var string
     */
    public $continueFrom;
    /**
     * Constructor method for EndOfPage
     * @uses EndOfPage::setContinueFrom()
     * @param string $continueFrom
     */
    public function __construct($continueFrom = null)
    {
        $this
            ->setContinueFrom($continueFrom);
    }
    /**
     * Get continueFrom value
     * @return string|null
     */
    public function getContinueFrom()
    {
        return $this->continueFrom;
    }
    /**
     * Set continueFrom value
     * @param string $continueFrom
     * @return \StructType\EndOfPage
     */
    public function setContinueFrom($continueFrom = null)
    {
        // validation for constraint: string
        if (!is_null($continueFrom) && !is_string($continueFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continueFrom, true), gettype($continueFrom)), __LINE__);
        }
        $this->continueFrom = $continueFrom;
        return $this;
    }
}
