<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAction StructType
 * @subpackage Structs
 */
class CreateAction extends ActionType
{
    /**
     * The classId
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $classId;
    /**
     * The objectId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}
     * @var string
     */
    public $objectId;
    /**
     * The autoUniqueContainmentName
     * @var bool
     */
    public $autoUniqueContainmentName;
    /**
     * The defineSecurityParentage
     * @var bool
     */
    public $defineSecurityParentage;
    /**
     * The versionSeriesId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}
     * @var string
     */
    public $versionSeriesId;
    /**
     * The reservationType
     * @var string
     */
    public $reservationType;
    /**
     * Constructor method for CreateAction
     * @uses CreateAction::setClassId()
     * @uses CreateAction::setObjectId()
     * @uses CreateAction::setAutoUniqueContainmentName()
     * @uses CreateAction::setDefineSecurityParentage()
     * @uses CreateAction::setVersionSeriesId()
     * @uses CreateAction::setReservationType()
     * @param string $classId
     * @param string $objectId
     * @param bool $autoUniqueContainmentName
     * @param bool $defineSecurityParentage
     * @param string $versionSeriesId
     * @param string $reservationType
     */
    public function __construct($classId = null, $objectId = null, $autoUniqueContainmentName = null, $defineSecurityParentage = null, $versionSeriesId = null, $reservationType = null)
    {
        $this
            ->setClassId($classId)
            ->setObjectId($objectId)
            ->setAutoUniqueContainmentName($autoUniqueContainmentName)
            ->setDefineSecurityParentage($defineSecurityParentage)
            ->setVersionSeriesId($versionSeriesId)
            ->setReservationType($reservationType);
    }
    /**
     * Get classId value
     * @return string
     */
    public function getClassId()
    {
        return $this->classId;
    }
    /**
     * Set classId value
     * @param string $classId
     * @return \StructType\CreateAction
     */
    public function setClassId($classId = null)
    {
        // validation for constraint: string
        if (!is_null($classId) && !is_string($classId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classId, true), gettype($classId)), __LINE__);
        }
        $this->classId = $classId;
        return $this;
    }
    /**
     * Get objectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param string $objectId
     * @return \StructType\CreateAction
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\})
        if (!is_null($objectId) && !preg_match('/\\{[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}\\}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}', var_export($objectId, true)), __LINE__);
        }
        $this->objectId = $objectId;
        return $this;
    }
    /**
     * Get autoUniqueContainmentName value
     * @return bool|null
     */
    public function getAutoUniqueContainmentName()
    {
        return $this->autoUniqueContainmentName;
    }
    /**
     * Set autoUniqueContainmentName value
     * @param bool $autoUniqueContainmentName
     * @return \StructType\CreateAction
     */
    public function setAutoUniqueContainmentName($autoUniqueContainmentName = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoUniqueContainmentName) && !is_bool($autoUniqueContainmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoUniqueContainmentName, true), gettype($autoUniqueContainmentName)), __LINE__);
        }
        $this->autoUniqueContainmentName = $autoUniqueContainmentName;
        return $this;
    }
    /**
     * Get defineSecurityParentage value
     * @return bool|null
     */
    public function getDefineSecurityParentage()
    {
        return $this->defineSecurityParentage;
    }
    /**
     * Set defineSecurityParentage value
     * @param bool $defineSecurityParentage
     * @return \StructType\CreateAction
     */
    public function setDefineSecurityParentage($defineSecurityParentage = null)
    {
        // validation for constraint: boolean
        if (!is_null($defineSecurityParentage) && !is_bool($defineSecurityParentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defineSecurityParentage, true), gettype($defineSecurityParentage)), __LINE__);
        }
        $this->defineSecurityParentage = $defineSecurityParentage;
        return $this;
    }
    /**
     * Get versionSeriesId value
     * @return string|null
     */
    public function getVersionSeriesId()
    {
        return $this->versionSeriesId;
    }
    /**
     * Set versionSeriesId value
     * @param string $versionSeriesId
     * @return \StructType\CreateAction
     */
    public function setVersionSeriesId($versionSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($versionSeriesId) && !is_string($versionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionSeriesId, true), gettype($versionSeriesId)), __LINE__);
        }
        // validation for constraint: pattern(\{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\})
        if (!is_null($versionSeriesId) && !preg_match('/\\{[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}\\}/', $versionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}', var_export($versionSeriesId, true)), __LINE__);
        }
        $this->versionSeriesId = $versionSeriesId;
        return $this;
    }
    /**
     * Get reservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->reservationType;
    }
    /**
     * Set reservationType value
     * @uses \EnumType\ReservationType::valueIsValid()
     * @uses \EnumType\ReservationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationType
     * @return \StructType\CreateAction
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReservationType::valueIsValid($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReservationType', is_array($reservationType) ? implode(', ', $reservationType) : var_export($reservationType, true), implode(', ', \EnumType\ReservationType::getValidValues())), __LINE__);
        }
        $this->reservationType = $reservationType;
        return $this;
    }
}
