<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentType StructType
 * @subpackage Structs
 */
abstract class ContentType extends AbstractStructBase
{
    /**
     * The size
     * @var int
     */
    public $size;
    /**
     * Constructor method for ContentType
     * @uses ContentType::setSize()
     * @param int $size
     */
    public function __construct($size = null)
    {
        $this
            ->setSize($size);
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\ContentType
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
}
