<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentElementResponse StructType
 * @subpackage Structs
 */
class ContentElementResponse extends ContentResponseType
{
    /**
     * The SourceSpecification
     * @var \StructType\ObjectReference
     */
    public $SourceSpecification;
    /**
     * The ElementSpecification
     * @var \StructType\ElementSpecificationType
     */
    public $ElementSpecification;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContentType
     */
    public $Content;
    /**
     * The continueFrom
     * @var string
     */
    public $continueFrom;
    /**
     * The retrievalName
     * @var string
     */
    public $retrievalName;
    /**
     * The totalSize
     * @var int
     */
    public $totalSize;
    /**
     * Constructor method for ContentElementResponse
     * @uses ContentElementResponse::setSourceSpecification()
     * @uses ContentElementResponse::setElementSpecification()
     * @uses ContentElementResponse::setContent()
     * @uses ContentElementResponse::setContinueFrom()
     * @uses ContentElementResponse::setRetrievalName()
     * @uses ContentElementResponse::setTotalSize()
     * @param \StructType\ObjectReference $sourceSpecification
     * @param \StructType\ElementSpecificationType $elementSpecification
     * @param \StructType\ContentType $content
     * @param string $continueFrom
     * @param string $retrievalName
     * @param int $totalSize
     */
    public function __construct(\StructType\ObjectReference $sourceSpecification = null, \StructType\ElementSpecificationType $elementSpecification = null, \StructType\ContentType $content = null, $continueFrom = null, $retrievalName = null, $totalSize = null)
    {
        $this
            ->setSourceSpecification($sourceSpecification)
            ->setElementSpecification($elementSpecification)
            ->setContent($content)
            ->setContinueFrom($continueFrom)
            ->setRetrievalName($retrievalName)
            ->setTotalSize($totalSize);
    }
    /**
     * Get SourceSpecification value
     * @return \StructType\ObjectReference|null
     */
    public function getSourceSpecification()
    {
        return $this->SourceSpecification;
    }
    /**
     * Set SourceSpecification value
     * @param \StructType\ObjectReference $sourceSpecification
     * @return \StructType\ContentElementResponse
     */
    public function setSourceSpecification(\StructType\ObjectReference $sourceSpecification = null)
    {
        $this->SourceSpecification = $sourceSpecification;
        return $this;
    }
    /**
     * Get ElementSpecification value
     * @return \StructType\ElementSpecificationType|null
     */
    public function getElementSpecification()
    {
        return $this->ElementSpecification;
    }
    /**
     * Set ElementSpecification value
     * @param \StructType\ElementSpecificationType $elementSpecification
     * @return \StructType\ContentElementResponse
     */
    public function setElementSpecification(\StructType\ElementSpecificationType $elementSpecification = null)
    {
        $this->ElementSpecification = $elementSpecification;
        return $this;
    }
    /**
     * Get Content value
     * @return \StructType\ContentType|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param \StructType\ContentType $content
     * @return \StructType\ContentElementResponse
     */
    public function setContent(\StructType\ContentType $content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get continueFrom value
     * @return string|null
     */
    public function getContinueFrom()
    {
        return $this->continueFrom;
    }
    /**
     * Set continueFrom value
     * @param string $continueFrom
     * @return \StructType\ContentElementResponse
     */
    public function setContinueFrom($continueFrom = null)
    {
        // validation for constraint: string
        if (!is_null($continueFrom) && !is_string($continueFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continueFrom, true), gettype($continueFrom)), __LINE__);
        }
        $this->continueFrom = $continueFrom;
        return $this;
    }
    /**
     * Get retrievalName value
     * @return string|null
     */
    public function getRetrievalName()
    {
        return $this->retrievalName;
    }
    /**
     * Set retrievalName value
     * @param string $retrievalName
     * @return \StructType\ContentElementResponse
     */
    public function setRetrievalName($retrievalName = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalName) && !is_string($retrievalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrievalName, true), gettype($retrievalName)), __LINE__);
        }
        $this->retrievalName = $retrievalName;
        return $this;
    }
    /**
     * Get totalSize value
     * @return int|null
     */
    public function getTotalSize()
    {
        return $this->totalSize;
    }
    /**
     * Set totalSize value
     * @param int $totalSize
     * @return \StructType\ContentElementResponse
     */
    public function setTotalSize($totalSize = null)
    {
        // validation for constraint: int
        if (!is_null($totalSize) && !(is_int($totalSize) || ctype_digit($totalSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSize, true), gettype($totalSize)), __LINE__);
        }
        $this->totalSize = $totalSize;
        return $this;
    }
}
