<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplySecurityTemplateAction StructType
 * @subpackage Structs
 */
class ApplySecurityTemplateAction extends ActionType
{
    /**
     * The applyStateId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}
     * - use: required
     * @var string
     */
    public $applyStateId;
    /**
     * Constructor method for ApplySecurityTemplateAction
     * @uses ApplySecurityTemplateAction::setApplyStateId()
     * @param string $applyStateId
     */
    public function __construct($applyStateId = null)
    {
        $this
            ->setApplyStateId($applyStateId);
    }
    /**
     * Get applyStateId value
     * @return string
     */
    public function getApplyStateId()
    {
        return $this->applyStateId;
    }
    /**
     * Set applyStateId value
     * @param string $applyStateId
     * @return \StructType\ApplySecurityTemplateAction
     */
    public function setApplyStateId($applyStateId = null)
    {
        // validation for constraint: string
        if (!is_null($applyStateId) && !is_string($applyStateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyStateId, true), gettype($applyStateId)), __LINE__);
        }
        // validation for constraint: pattern(\{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\})
        if (!is_null($applyStateId) && !preg_match('/\\{[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}\\}/', $applyStateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}', var_export($applyStateId, true)), __LINE__);
        }
        $this->applyStateId = $applyStateId;
        return $this;
    }
}
