<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithObjectIdentityType StructType
 * @subpackage Structs
 */
abstract class WithObjectIdentityType extends ObjectEntryType
{
    /**
     * The classId
     * @var string
     */
    public $classId;
    /**
     * The objectId
     * @var string
     */
    public $objectId;
    /**
     * The objectStore
     * @var string
     */
    public $objectStore;
    /**
     * The serializationDuplicate
     * @var bool
     */
    public $serializationDuplicate;
    /**
     * Constructor method for WithObjectIdentityType
     * @uses WithObjectIdentityType::setClassId()
     * @uses WithObjectIdentityType::setObjectId()
     * @uses WithObjectIdentityType::setObjectStore()
     * @uses WithObjectIdentityType::setSerializationDuplicate()
     * @param string $classId
     * @param string $objectId
     * @param string $objectStore
     * @param bool $serializationDuplicate
     */
    public function __construct($classId = null, $objectId = null, $objectStore = null, $serializationDuplicate = null)
    {
        $this
            ->setClassId($classId)
            ->setObjectId($objectId)
            ->setObjectStore($objectStore)
            ->setSerializationDuplicate($serializationDuplicate);
    }
    /**
     * Get classId value
     * @return string|null
     */
    public function getClassId()
    {
        return $this->classId;
    }
    /**
     * Set classId value
     * @param string $classId
     * @return \StructType\WithObjectIdentityType
     */
    public function setClassId($classId = null)
    {
        // validation for constraint: string
        if (!is_null($classId) && !is_string($classId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classId, true), gettype($classId)), __LINE__);
        }
        $this->classId = $classId;
        return $this;
    }
    /**
     * Get objectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param string $objectId
     * @return \StructType\WithObjectIdentityType
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        $this->objectId = $objectId;
        return $this;
    }
    /**
     * Get objectStore value
     * @return string|null
     */
    public function getObjectStore()
    {
        return $this->objectStore;
    }
    /**
     * Set objectStore value
     * @param string $objectStore
     * @return \StructType\WithObjectIdentityType
     */
    public function setObjectStore($objectStore = null)
    {
        // validation for constraint: string
        if (!is_null($objectStore) && !is_string($objectStore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectStore, true), gettype($objectStore)), __LINE__);
        }
        $this->objectStore = $objectStore;
        return $this;
    }
    /**
     * Get serializationDuplicate value
     * @return bool|null
     */
    public function getSerializationDuplicate()
    {
        return $this->serializationDuplicate;
    }
    /**
     * Set serializationDuplicate value
     * @param bool $serializationDuplicate
     * @return \StructType\WithObjectIdentityType
     */
    public function setSerializationDuplicate($serializationDuplicate = null)
    {
        // validation for constraint: boolean
        if (!is_null($serializationDuplicate) && !is_bool($serializationDuplicate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serializationDuplicate, true), gettype($serializationDuplicate)), __LINE__);
        }
        $this->serializationDuplicate = $serializationDuplicate;
        return $this;
    }
}
