<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnevaluatedCollection StructType
 * @subpackage Structs
 */
class UnevaluatedCollection extends PropertyType
{
    /**
     * The ParentReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ObjectReference
     */
    public $ParentReference;
    /**
     * The collectionType
     * @var string
     */
    public $collectionType;
    /**
     * Constructor method for UnevaluatedCollection
     * @uses UnevaluatedCollection::setParentReference()
     * @uses UnevaluatedCollection::setCollectionType()
     * @param \StructType\ObjectReference $parentReference
     * @param string $collectionType
     */
    public function __construct(\StructType\ObjectReference $parentReference = null, $collectionType = null)
    {
        $this
            ->setParentReference($parentReference)
            ->setCollectionType($collectionType);
    }
    /**
     * Get ParentReference value
     * @return \StructType\ObjectReference|null
     */
    public function getParentReference()
    {
        return $this->ParentReference;
    }
    /**
     * Set ParentReference value
     * @param \StructType\ObjectReference $parentReference
     * @return \StructType\UnevaluatedCollection
     */
    public function setParentReference(\StructType\ObjectReference $parentReference = null)
    {
        $this->ParentReference = $parentReference;
        return $this;
    }
    /**
     * Get collectionType value
     * @return string|null
     */
    public function getCollectionType()
    {
        return $this->collectionType;
    }
    /**
     * Set collectionType value
     * @uses \EnumType\CollectionType::valueIsValid()
     * @uses \EnumType\CollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $collectionType
     * @return \StructType\UnevaluatedCollection
     */
    public function setCollectionType($collectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CollectionType::valueIsValid($collectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CollectionType', is_array($collectionType) ? implode(', ', $collectionType) : var_export($collectionType, true), implode(', ', \EnumType\CollectionType::getValidValues())), __LINE__);
        }
        $this->collectionType = $collectionType;
        return $this;
    }
}
