<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoredSearch StructType
 * @subpackage Structs
 */
class StoredSearch extends SearchRequestType
{
    /**
     * The SearchObject
     * @var \StructType\ObjectReference
     */
    public $SearchObject;
    /**
     * The ExecuteXML
     * @var \StructType\ExecuteXML
     */
    public $ExecuteXML;
    /**
     * The repositorySearchMode
     * @var string
     */
    public $repositorySearchMode;
    /**
     * Constructor method for StoredSearch
     * @uses StoredSearch::setSearchObject()
     * @uses StoredSearch::setExecuteXML()
     * @uses StoredSearch::setRepositorySearchMode()
     * @param \StructType\ObjectReference $searchObject
     * @param \StructType\ExecuteXML $executeXML
     * @param string $repositorySearchMode
     */
    public function __construct(\StructType\ObjectReference $searchObject = null, \StructType\ExecuteXML $executeXML = null, $repositorySearchMode = null)
    {
        $this
            ->setSearchObject($searchObject)
            ->setExecuteXML($executeXML)
            ->setRepositorySearchMode($repositorySearchMode);
    }
    /**
     * Get SearchObject value
     * @return \StructType\ObjectReference|null
     */
    public function getSearchObject()
    {
        return $this->SearchObject;
    }
    /**
     * Set SearchObject value
     * @param \StructType\ObjectReference $searchObject
     * @return \StructType\StoredSearch
     */
    public function setSearchObject(\StructType\ObjectReference $searchObject = null)
    {
        $this->SearchObject = $searchObject;
        return $this;
    }
    /**
     * Get ExecuteXML value
     * @return \StructType\ExecuteXML|null
     */
    public function getExecuteXML()
    {
        return $this->ExecuteXML;
    }
    /**
     * Set ExecuteXML value
     * @param \StructType\ExecuteXML $executeXML
     * @return \StructType\StoredSearch
     */
    public function setExecuteXML(\StructType\ExecuteXML $executeXML = null)
    {
        $this->ExecuteXML = $executeXML;
        return $this;
    }
    /**
     * Get repositorySearchMode value
     * @return string|null
     */
    public function getRepositorySearchMode()
    {
        return $this->repositorySearchMode;
    }
    /**
     * Set repositorySearchMode value
     * @uses \EnumType\RepositorySearchModeType::valueIsValid()
     * @uses \EnumType\RepositorySearchModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repositorySearchMode
     * @return \StructType\StoredSearch
     */
    public function setRepositorySearchMode($repositorySearchMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RepositorySearchModeType::valueIsValid($repositorySearchMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RepositorySearchModeType', is_array($repositorySearchMode) ? implode(', ', $repositorySearchMode) : var_export($repositorySearchMode, true), implode(', ', \EnumType\RepositorySearchModeType::getValidValues())), __LINE__);
        }
        $this->repositorySearchMode = $repositorySearchMode;
        return $this;
    }
}
