<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingletonString StructType
 * @subpackage Structs
 */
class SingletonString extends ModifiablePropertyType
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The encoding
     * @var string
     */
    public $encoding;
    /**
     * Constructor method for SingletonString
     * @uses SingletonString::setValue()
     * @uses SingletonString::setEncoding()
     * @param string $value
     * @param string $encoding
     */
    public function __construct($value = null, $encoding = null)
    {
        $this
            ->setValue($value)
            ->setEncoding($encoding);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\SingletonString
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @uses \EnumType\StringEncodingType::valueIsValid()
     * @uses \EnumType\StringEncodingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encoding
     * @return \StructType\SingletonString
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StringEncodingType::valueIsValid($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StringEncodingType', is_array($encoding) ? implode(', ', $encoding) : var_export($encoding, true), implode(', ', \EnumType\StringEncodingType::getValidValues())), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
}
