<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleObjectResponse StructType
 * @subpackage Structs
 */
class SingleObjectResponse extends ObjectResponseType
{
    /**
     * The Object
     * @var \StructType\ObjectValue
     */
    public $Object;
    /**
     * Constructor method for SingleObjectResponse
     * @uses SingleObjectResponse::setObject()
     * @param \StructType\ObjectValue $object
     */
    public function __construct(\StructType\ObjectValue $object = null)
    {
        $this
            ->setObject($object);
    }
    /**
     * Get Object value
     * @return \StructType\ObjectValue|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \StructType\ObjectValue $object
     * @return \StructType\SingleObjectResponse
     */
    public function setObject(\StructType\ObjectValue $object = null)
    {
        $this->Object = $object;
        return $this;
    }
}
