<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRequestType StructType
 * @subpackage Structs
 */
abstract class SearchRequestType extends AbstractStructBase
{
    /**
     * The SelectionFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PropertyFilterType
     */
    public $SelectionFilter;
    /**
     * The maxElements
     * @var int
     */
    public $maxElements;
    /**
     * The continueFrom
     * @var string
     */
    public $continueFrom;
    /**
     * The continuable
     * @var bool
     */
    public $continuable;
    /**
     * Constructor method for SearchRequestType
     * @uses SearchRequestType::setSelectionFilter()
     * @uses SearchRequestType::setMaxElements()
     * @uses SearchRequestType::setContinueFrom()
     * @uses SearchRequestType::setContinuable()
     * @param \StructType\PropertyFilterType $selectionFilter
     * @param int $maxElements
     * @param string $continueFrom
     * @param bool $continuable
     */
    public function __construct(\StructType\PropertyFilterType $selectionFilter = null, $maxElements = null, $continueFrom = null, $continuable = null)
    {
        $this
            ->setSelectionFilter($selectionFilter)
            ->setMaxElements($maxElements)
            ->setContinueFrom($continueFrom)
            ->setContinuable($continuable);
    }
    /**
     * Get SelectionFilter value
     * @return \StructType\PropertyFilterType|null
     */
    public function getSelectionFilter()
    {
        return $this->SelectionFilter;
    }
    /**
     * Set SelectionFilter value
     * @param \StructType\PropertyFilterType $selectionFilter
     * @return \StructType\SearchRequestType
     */
    public function setSelectionFilter(\StructType\PropertyFilterType $selectionFilter = null)
    {
        $this->SelectionFilter = $selectionFilter;
        return $this;
    }
    /**
     * Get maxElements value
     * @return int|null
     */
    public function getMaxElements()
    {
        return $this->maxElements;
    }
    /**
     * Set maxElements value
     * @param int $maxElements
     * @return \StructType\SearchRequestType
     */
    public function setMaxElements($maxElements = null)
    {
        // validation for constraint: int
        if (!is_null($maxElements) && !(is_int($maxElements) || ctype_digit($maxElements))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxElements, true), gettype($maxElements)), __LINE__);
        }
        $this->maxElements = $maxElements;
        return $this;
    }
    /**
     * Get continueFrom value
     * @return string|null
     */
    public function getContinueFrom()
    {
        return $this->continueFrom;
    }
    /**
     * Set continueFrom value
     * @param string $continueFrom
     * @return \StructType\SearchRequestType
     */
    public function setContinueFrom($continueFrom = null)
    {
        // validation for constraint: string
        if (!is_null($continueFrom) && !is_string($continueFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continueFrom, true), gettype($continueFrom)), __LINE__);
        }
        $this->continueFrom = $continueFrom;
        return $this;
    }
    /**
     * Get continuable value
     * @return bool|null
     */
    public function getContinuable()
    {
        return $this->continuable;
    }
    /**
     * Set continuable value
     * @param bool $continuable
     * @return \StructType\SearchRequestType
     */
    public function setContinuable($continuable = null)
    {
        // validation for constraint: boolean
        if (!is_null($continuable) && !is_bool($continuable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($continuable, true), gettype($continuable)), __LINE__);
        }
        $this->continuable = $continuable;
        return $this;
    }
}
