<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrincipalSearch StructType
 * @subpackage Structs
 */
class PrincipalSearch extends SearchRequestType
{
    /**
     * The SearchRealm
     * @var string
     */
    public $SearchRealm;
    /**
     * The SearchPattern
     * @var string
     */
    public $SearchPattern;
    /**
     * The includeUsers
     * @var bool
     */
    public $includeUsers;
    /**
     * The includeGroups
     * @var bool
     */
    public $includeGroups;
    /**
     * The principalSearchType
     * @var string
     */
    public $principalSearchType;
    /**
     * The principalSearchAttribute
     * @var string
     */
    public $principalSearchAttribute;
    /**
     * The principalSort
     * @var string
     */
    public $principalSort;
    /**
     * Constructor method for PrincipalSearch
     * @uses PrincipalSearch::setSearchRealm()
     * @uses PrincipalSearch::setSearchPattern()
     * @uses PrincipalSearch::setIncludeUsers()
     * @uses PrincipalSearch::setIncludeGroups()
     * @uses PrincipalSearch::setPrincipalSearchType()
     * @uses PrincipalSearch::setPrincipalSearchAttribute()
     * @uses PrincipalSearch::setPrincipalSort()
     * @param string $searchRealm
     * @param string $searchPattern
     * @param bool $includeUsers
     * @param bool $includeGroups
     * @param string $principalSearchType
     * @param string $principalSearchAttribute
     * @param string $principalSort
     */
    public function __construct($searchRealm = null, $searchPattern = null, $includeUsers = null, $includeGroups = null, $principalSearchType = null, $principalSearchAttribute = null, $principalSort = null)
    {
        $this
            ->setSearchRealm($searchRealm)
            ->setSearchPattern($searchPattern)
            ->setIncludeUsers($includeUsers)
            ->setIncludeGroups($includeGroups)
            ->setPrincipalSearchType($principalSearchType)
            ->setPrincipalSearchAttribute($principalSearchAttribute)
            ->setPrincipalSort($principalSort);
    }
    /**
     * Get SearchRealm value
     * @return string|null
     */
    public function getSearchRealm()
    {
        return $this->SearchRealm;
    }
    /**
     * Set SearchRealm value
     * @param string $searchRealm
     * @return \StructType\PrincipalSearch
     */
    public function setSearchRealm($searchRealm = null)
    {
        // validation for constraint: string
        if (!is_null($searchRealm) && !is_string($searchRealm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchRealm, true), gettype($searchRealm)), __LINE__);
        }
        $this->SearchRealm = $searchRealm;
        return $this;
    }
    /**
     * Get SearchPattern value
     * @return string|null
     */
    public function getSearchPattern()
    {
        return $this->SearchPattern;
    }
    /**
     * Set SearchPattern value
     * @param string $searchPattern
     * @return \StructType\PrincipalSearch
     */
    public function setSearchPattern($searchPattern = null)
    {
        // validation for constraint: string
        if (!is_null($searchPattern) && !is_string($searchPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchPattern, true), gettype($searchPattern)), __LINE__);
        }
        $this->SearchPattern = $searchPattern;
        return $this;
    }
    /**
     * Get includeUsers value
     * @return bool|null
     */
    public function getIncludeUsers()
    {
        return $this->includeUsers;
    }
    /**
     * Set includeUsers value
     * @param bool $includeUsers
     * @return \StructType\PrincipalSearch
     */
    public function setIncludeUsers($includeUsers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeUsers) && !is_bool($includeUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeUsers, true), gettype($includeUsers)), __LINE__);
        }
        $this->includeUsers = $includeUsers;
        return $this;
    }
    /**
     * Get includeGroups value
     * @return bool|null
     */
    public function getIncludeGroups()
    {
        return $this->includeGroups;
    }
    /**
     * Set includeGroups value
     * @param bool $includeGroups
     * @return \StructType\PrincipalSearch
     */
    public function setIncludeGroups($includeGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeGroups) && !is_bool($includeGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeGroups, true), gettype($includeGroups)), __LINE__);
        }
        $this->includeGroups = $includeGroups;
        return $this;
    }
    /**
     * Get principalSearchType value
     * @return string|null
     */
    public function getPrincipalSearchType()
    {
        return $this->principalSearchType;
    }
    /**
     * Set principalSearchType value
     * @param string $principalSearchType
     * @return \StructType\PrincipalSearch
     */
    public function setPrincipalSearchType($principalSearchType = null)
    {
        // validation for constraint: string
        if (!is_null($principalSearchType) && !is_string($principalSearchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principalSearchType, true), gettype($principalSearchType)), __LINE__);
        }
        $this->principalSearchType = $principalSearchType;
        return $this;
    }
    /**
     * Get principalSearchAttribute value
     * @return string|null
     */
    public function getPrincipalSearchAttribute()
    {
        return $this->principalSearchAttribute;
    }
    /**
     * Set principalSearchAttribute value
     * @param string $principalSearchAttribute
     * @return \StructType\PrincipalSearch
     */
    public function setPrincipalSearchAttribute($principalSearchAttribute = null)
    {
        // validation for constraint: string
        if (!is_null($principalSearchAttribute) && !is_string($principalSearchAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principalSearchAttribute, true), gettype($principalSearchAttribute)), __LINE__);
        }
        $this->principalSearchAttribute = $principalSearchAttribute;
        return $this;
    }
    /**
     * Get principalSort value
     * @return string|null
     */
    public function getPrincipalSort()
    {
        return $this->principalSort;
    }
    /**
     * Set principalSort value
     * @param string $principalSort
     * @return \StructType\PrincipalSearch
     */
    public function setPrincipalSort($principalSort = null)
    {
        // validation for constraint: string
        if (!is_null($principalSort) && !is_string($principalSort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principalSort, true), gettype($principalSort)), __LINE__);
        }
        $this->principalSort = $principalSort;
        return $this;
    }
}
