<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectValue StructType
 * @subpackage Structs
 */
class ObjectValue extends WithObjectIdentityType
{
    /**
     * The Property
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyType[]
     */
    public $Property;
    /**
     * The updateSequenceNumber
     * @var int
     */
    public $updateSequenceNumber;
    /**
     * The accessAllowed
     * @var int
     */
    public $accessAllowed;
    /**
     * The superClasses
     * @var string[]
     */
    public $superClasses;
    /**
     * Constructor method for ObjectValue
     * @uses ObjectValue::setProperty()
     * @uses ObjectValue::setUpdateSequenceNumber()
     * @uses ObjectValue::setAccessAllowed()
     * @uses ObjectValue::setSuperClasses()
     * @param \StructType\PropertyType[] $property
     * @param int $updateSequenceNumber
     * @param int $accessAllowed
     * @param string[] $superClasses
     */
    public function __construct(array $property = array(), $updateSequenceNumber = null, $accessAllowed = null, array $superClasses = array())
    {
        $this
            ->setProperty($property)
            ->setUpdateSequenceNumber($updateSequenceNumber)
            ->setAccessAllowed($accessAllowed)
            ->setSuperClasses($superClasses);
    }
    /**
     * Get Property value
     * @return \StructType\PropertyType[]|null
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * This method is responsible for validating the values passed to the setProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyForArrayConstraintsFromSetProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectValuePropertyItem) {
            // validation for constraint: itemType
            if (!$objectValuePropertyItem instanceof \StructType\PropertyType) {
                $invalidValues[] = is_object($objectValuePropertyItem) ? get_class($objectValuePropertyItem) : sprintf('%s(%s)', gettype($objectValuePropertyItem), var_export($objectValuePropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Property property can only contain items of type \StructType\PropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Property value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyType[] $property
     * @return \StructType\ObjectValue
     */
    public function setProperty(array $property = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyArrayErrorMessage = self::validatePropertyForArrayConstraintsFromSetProperty($property))) {
            throw new \InvalidArgumentException($propertyArrayErrorMessage, __LINE__);
        }
        $this->Property = $property;
        return $this;
    }
    /**
     * Add item to Property value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyType $item
     * @return \StructType\ObjectValue
     */
    public function addToProperty(\StructType\PropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyType) {
            throw new \InvalidArgumentException(sprintf('The Property property can only contain items of type \StructType\PropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Property[] = $item;
        return $this;
    }
    /**
     * Get updateSequenceNumber value
     * @return int|null
     */
    public function getUpdateSequenceNumber()
    {
        return $this->updateSequenceNumber;
    }
    /**
     * Set updateSequenceNumber value
     * @param int $updateSequenceNumber
     * @return \StructType\ObjectValue
     */
    public function setUpdateSequenceNumber($updateSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($updateSequenceNumber) && !(is_int($updateSequenceNumber) || ctype_digit($updateSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateSequenceNumber, true), gettype($updateSequenceNumber)), __LINE__);
        }
        $this->updateSequenceNumber = $updateSequenceNumber;
        return $this;
    }
    /**
     * Get accessAllowed value
     * @return int|null
     */
    public function getAccessAllowed()
    {
        return $this->accessAllowed;
    }
    /**
     * Set accessAllowed value
     * @param int $accessAllowed
     * @return \StructType\ObjectValue
     */
    public function setAccessAllowed($accessAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($accessAllowed) && !(is_int($accessAllowed) || ctype_digit($accessAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessAllowed, true), gettype($accessAllowed)), __LINE__);
        }
        $this->accessAllowed = $accessAllowed;
        return $this;
    }
    /**
     * Get superClasses value
     * @return string[]|null
     */
    public function getSuperClasses()
    {
        return $this->superClasses;
    }
    /**
     * This method is responsible for validating the values passed to the setSuperClasses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuperClasses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSuperClassesForArrayConstraintsFromSetSuperClasses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectValueSuperClassesItem) {
            // validation for constraint: itemType
            if (!is_string($objectValueSuperClassesItem)) {
                $invalidValues[] = is_object($objectValueSuperClassesItem) ? get_class($objectValueSuperClassesItem) : sprintf('%s(%s)', gettype($objectValueSuperClassesItem), var_export($objectValueSuperClassesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The superClasses property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set superClasses value
     * @throws \InvalidArgumentException
     * @param string[] $superClasses
     * @return \StructType\ObjectValue
     */
    public function setSuperClasses(array $superClasses = array())
    {
        // validation for constraint: array
        if ('' !== ($superClassesArrayErrorMessage = self::validateSuperClassesForArrayConstraintsFromSetSuperClasses($superClasses))) {
            throw new \InvalidArgumentException($superClassesArrayErrorMessage, __LINE__);
        }
        $this->superClasses = $superClasses;
        return $this;
    }
    /**
     * Add item to superClasses value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ObjectValue
     */
    public function addToSuperClasses($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The superClasses property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->superClasses[] = $item;
        return $this;
    }
}
