<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectSpecification StructType
 * Meta information extracted from the WSDL
 * - documentation: An ObjectSpecification can be used in a request anywhere that calls for an ObjectReference
 * @subpackage Structs
 */
class ObjectSpecification extends ObjectReference
{
    /**
     * The path
     * @var string
     */
    public $path;
    /**
     * The propertyId
     * @var string
     */
    public $propertyId;
    /**
     * The itemIndex
     * @var int
     */
    public $itemIndex;
    /**
     * The batchRef
     * @var string
     */
    public $batchRef;
    /**
     * Constructor method for ObjectSpecification
     * @uses ObjectSpecification::setPath()
     * @uses ObjectSpecification::setPropertyId()
     * @uses ObjectSpecification::setItemIndex()
     * @uses ObjectSpecification::setBatchRef()
     * @param string $path
     * @param string $propertyId
     * @param int $itemIndex
     * @param string $batchRef
     */
    public function __construct($path = null, $propertyId = null, $itemIndex = null, $batchRef = null)
    {
        $this
            ->setPath($path)
            ->setPropertyId($propertyId)
            ->setItemIndex($itemIndex)
            ->setBatchRef($batchRef);
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \StructType\ObjectSpecification
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($path, true), gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Get propertyId value
     * @return string|null
     */
    public function getPropertyId()
    {
        return $this->propertyId;
    }
    /**
     * Set propertyId value
     * @param string $propertyId
     * @return \StructType\ObjectSpecification
     */
    public function setPropertyId($propertyId = null)
    {
        // validation for constraint: string
        if (!is_null($propertyId) && !is_string($propertyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyId, true), gettype($propertyId)), __LINE__);
        }
        $this->propertyId = $propertyId;
        return $this;
    }
    /**
     * Get itemIndex value
     * @return int|null
     */
    public function getItemIndex()
    {
        return $this->itemIndex;
    }
    /**
     * Set itemIndex value
     * @param int $itemIndex
     * @return \StructType\ObjectSpecification
     */
    public function setItemIndex($itemIndex = null)
    {
        // validation for constraint: int
        if (!is_null($itemIndex) && !(is_int($itemIndex) || ctype_digit($itemIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemIndex, true), gettype($itemIndex)), __LINE__);
        }
        $this->itemIndex = $itemIndex;
        return $this;
    }
    /**
     * Get batchRef value
     * @return string|null
     */
    public function getBatchRef()
    {
        return $this->batchRef;
    }
    /**
     * Set batchRef value
     * @param string $batchRef
     * @return \StructType\ObjectSpecification
     */
    public function setBatchRef($batchRef = null)
    {
        // validation for constraint: string
        if (!is_null($batchRef) && !is_string($batchRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchRef, true), gettype($batchRef)), __LINE__);
        }
        $this->batchRef = $batchRef;
        return $this;
    }
}
