<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectSetResponse StructType
 * @subpackage Structs
 */
class ObjectSetResponse extends ObjectResponseType
{
    /**
     * The ObjectSet
     * @var \StructType\ObjectSetType
     */
    public $ObjectSet;
    /**
     * The collectionType
     * @var string
     */
    public $collectionType;
    /**
     * Constructor method for ObjectSetResponse
     * @uses ObjectSetResponse::setObjectSet()
     * @uses ObjectSetResponse::setCollectionType()
     * @param \StructType\ObjectSetType $objectSet
     * @param string $collectionType
     */
    public function __construct(\StructType\ObjectSetType $objectSet = null, $collectionType = null)
    {
        $this
            ->setObjectSet($objectSet)
            ->setCollectionType($collectionType);
    }
    /**
     * Get ObjectSet value
     * @return \StructType\ObjectSetType|null
     */
    public function getObjectSet()
    {
        return $this->ObjectSet;
    }
    /**
     * Set ObjectSet value
     * @param \StructType\ObjectSetType $objectSet
     * @return \StructType\ObjectSetResponse
     */
    public function setObjectSet(\StructType\ObjectSetType $objectSet = null)
    {
        $this->ObjectSet = $objectSet;
        return $this;
    }
    /**
     * Get collectionType value
     * @return string|null
     */
    public function getCollectionType()
    {
        return $this->collectionType;
    }
    /**
     * Set collectionType value
     * @uses \EnumType\CollectionType::valueIsValid()
     * @uses \EnumType\CollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $collectionType
     * @return \StructType\ObjectSetResponse
     */
    public function setCollectionType($collectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CollectionType::valueIsValid($collectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CollectionType', is_array($collectionType) ? implode(', ', $collectionType) : var_export($collectionType, true), implode(', ', \EnumType\CollectionType::getValidValues())), __LINE__);
        }
        $this->collectionType = $collectionType;
        return $this;
    }
}
