<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectRequestType StructType
 * @subpackage Structs
 */
class ObjectRequestType extends AbstractStructBase
{
    /**
     * The SourceSpecification
     * @var \StructType\ObjectReference
     */
    public $SourceSpecification;
    /**
     * The PropertyFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PropertyFilterType
     */
    public $PropertyFilter;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The cacheAllowed
     * @var bool
     */
    public $cacheAllowed;
    /**
     * The maxElements
     * @var int
     */
    public $maxElements;
    /**
     * The continueFrom
     * @var string
     */
    public $continueFrom;
    /**
     * Constructor method for ObjectRequestType
     * @uses ObjectRequestType::setSourceSpecification()
     * @uses ObjectRequestType::setPropertyFilter()
     * @uses ObjectRequestType::setId()
     * @uses ObjectRequestType::setCacheAllowed()
     * @uses ObjectRequestType::setMaxElements()
     * @uses ObjectRequestType::setContinueFrom()
     * @param \StructType\ObjectReference $sourceSpecification
     * @param \StructType\PropertyFilterType $propertyFilter
     * @param string $id
     * @param bool $cacheAllowed
     * @param int $maxElements
     * @param string $continueFrom
     */
    public function __construct(\StructType\ObjectReference $sourceSpecification = null, \StructType\PropertyFilterType $propertyFilter = null, $id = null, $cacheAllowed = null, $maxElements = null, $continueFrom = null)
    {
        $this
            ->setSourceSpecification($sourceSpecification)
            ->setPropertyFilter($propertyFilter)
            ->setId($id)
            ->setCacheAllowed($cacheAllowed)
            ->setMaxElements($maxElements)
            ->setContinueFrom($continueFrom);
    }
    /**
     * Get SourceSpecification value
     * @return \StructType\ObjectReference|null
     */
    public function getSourceSpecification()
    {
        return $this->SourceSpecification;
    }
    /**
     * Set SourceSpecification value
     * @param \StructType\ObjectReference $sourceSpecification
     * @return \StructType\ObjectRequestType
     */
    public function setSourceSpecification(\StructType\ObjectReference $sourceSpecification = null)
    {
        $this->SourceSpecification = $sourceSpecification;
        return $this;
    }
    /**
     * Get PropertyFilter value
     * @return \StructType\PropertyFilterType|null
     */
    public function getPropertyFilter()
    {
        return $this->PropertyFilter;
    }
    /**
     * Set PropertyFilter value
     * @param \StructType\PropertyFilterType $propertyFilter
     * @return \StructType\ObjectRequestType
     */
    public function setPropertyFilter(\StructType\PropertyFilterType $propertyFilter = null)
    {
        $this->PropertyFilter = $propertyFilter;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ObjectRequestType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get cacheAllowed value
     * @return bool|null
     */
    public function getCacheAllowed()
    {
        return $this->cacheAllowed;
    }
    /**
     * Set cacheAllowed value
     * @param bool $cacheAllowed
     * @return \StructType\ObjectRequestType
     */
    public function setCacheAllowed($cacheAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($cacheAllowed) && !is_bool($cacheAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cacheAllowed, true), gettype($cacheAllowed)), __LINE__);
        }
        $this->cacheAllowed = $cacheAllowed;
        return $this;
    }
    /**
     * Get maxElements value
     * @return int|null
     */
    public function getMaxElements()
    {
        return $this->maxElements;
    }
    /**
     * Set maxElements value
     * @param int $maxElements
     * @return \StructType\ObjectRequestType
     */
    public function setMaxElements($maxElements = null)
    {
        // validation for constraint: int
        if (!is_null($maxElements) && !(is_int($maxElements) || ctype_digit($maxElements))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxElements, true), gettype($maxElements)), __LINE__);
        }
        $this->maxElements = $maxElements;
        return $this;
    }
    /**
     * Get continueFrom value
     * @return string|null
     */
    public function getContinueFrom()
    {
        return $this->continueFrom;
    }
    /**
     * Set continueFrom value
     * @param string $continueFrom
     * @return \StructType\ObjectRequestType
     */
    public function setContinueFrom($continueFrom = null)
    {
        // validation for constraint: string
        if (!is_null($continueFrom) && !is_string($continueFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continueFrom, true), gettype($continueFrom)), __LINE__);
        }
        $this->continueFrom = $continueFrom;
        return $this;
    }
}
