<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveContentAction StructType
 * @subpackage Structs
 */
class MoveContentAction extends ActionType
{
    /**
     * The targetPolicyId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}
     * - use: required
     * @var string
     */
    public $targetPolicyId;
    /**
     * The moveAllVersions
     * @var bool
     */
    public $moveAllVersions;
    /**
     * Constructor method for MoveContentAction
     * @uses MoveContentAction::setTargetPolicyId()
     * @uses MoveContentAction::setMoveAllVersions()
     * @param string $targetPolicyId
     * @param bool $moveAllVersions
     */
    public function __construct($targetPolicyId = null, $moveAllVersions = null)
    {
        $this
            ->setTargetPolicyId($targetPolicyId)
            ->setMoveAllVersions($moveAllVersions);
    }
    /**
     * Get targetPolicyId value
     * @return string
     */
    public function getTargetPolicyId()
    {
        return $this->targetPolicyId;
    }
    /**
     * Set targetPolicyId value
     * @param string $targetPolicyId
     * @return \StructType\MoveContentAction
     */
    public function setTargetPolicyId($targetPolicyId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPolicyId) && !is_string($targetPolicyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPolicyId, true), gettype($targetPolicyId)), __LINE__);
        }
        // validation for constraint: pattern(\{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\})
        if (!is_null($targetPolicyId) && !preg_match('/\\{[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}\\}/', $targetPolicyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}', var_export($targetPolicyId, true)), __LINE__);
        }
        $this->targetPolicyId = $targetPolicyId;
        return $this;
    }
    /**
     * Get moveAllVersions value
     * @return bool|null
     */
    public function getMoveAllVersions()
    {
        return $this->moveAllVersions;
    }
    /**
     * Set moveAllVersions value
     * @param bool $moveAllVersions
     * @return \StructType\MoveContentAction
     */
    public function setMoveAllVersions($moveAllVersions = null)
    {
        // validation for constraint: boolean
        if (!is_null($moveAllVersions) && !is_bool($moveAllVersions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moveAllVersions, true), gettype($moveAllVersions)), __LINE__);
        }
        $this->moveAllVersions = $moveAllVersions;
        return $this;
    }
}
