<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergedScope StructType
 * @subpackage Structs
 */
class MergedScope extends SearchScopeType
{
    /**
     * The ComponentScope
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \StructType\SearchScopeType[]
     */
    public $ComponentScope;
    /**
     * The mergeMode
     * @var string
     */
    public $mergeMode;
    /**
     * Constructor method for MergedScope
     * @uses MergedScope::setComponentScope()
     * @uses MergedScope::setMergeMode()
     * @param \StructType\SearchScopeType[] $componentScope
     * @param string $mergeMode
     */
    public function __construct(array $componentScope = array(), $mergeMode = null)
    {
        $this
            ->setComponentScope($componentScope)
            ->setMergeMode($mergeMode);
    }
    /**
     * Get ComponentScope value
     * @return \StructType\SearchScopeType[]
     */
    public function getComponentScope()
    {
        return $this->ComponentScope;
    }
    /**
     * This method is responsible for validating the values passed to the setComponentScope method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComponentScope method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComponentScopeForArrayConstraintsFromSetComponentScope(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mergedScopeComponentScopeItem) {
            // validation for constraint: itemType
            if (!$mergedScopeComponentScopeItem instanceof \StructType\SearchScopeType) {
                $invalidValues[] = is_object($mergedScopeComponentScopeItem) ? get_class($mergedScopeComponentScopeItem) : sprintf('%s(%s)', gettype($mergedScopeComponentScopeItem), var_export($mergedScopeComponentScopeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ComponentScope property can only contain items of type \StructType\SearchScopeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ComponentScope value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchScopeType[] $componentScope
     * @return \StructType\MergedScope
     */
    public function setComponentScope(array $componentScope = array())
    {
        // validation for constraint: array
        if ('' !== ($componentScopeArrayErrorMessage = self::validateComponentScopeForArrayConstraintsFromSetComponentScope($componentScope))) {
            throw new \InvalidArgumentException($componentScopeArrayErrorMessage, __LINE__);
        }
        $this->ComponentScope = $componentScope;
        return $this;
    }
    /**
     * Add item to ComponentScope value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchScopeType $item
     * @return \StructType\MergedScope
     */
    public function addToComponentScope(\StructType\SearchScopeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchScopeType) {
            throw new \InvalidArgumentException(sprintf('The ComponentScope property can only contain items of type \StructType\SearchScopeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ComponentScope[] = $item;
        return $this;
    }
    /**
     * Get mergeMode value
     * @return string|null
     */
    public function getMergeMode()
    {
        return $this->mergeMode;
    }
    /**
     * Set mergeMode value
     * @param string $mergeMode
     * @return \StructType\MergedScope
     */
    public function setMergeMode($mergeMode = null)
    {
        // validation for constraint: string
        if (!is_null($mergeMode) && !is_string($mergeMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergeMode, true), gettype($mergeMode)), __LINE__);
        }
        $this->mergeMode = $mergeMode;
        return $this;
    }
}
