<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Localization StructType
 * @subpackage Structs
 */
class Localization extends AbstractStructBase
{
    /**
     * The Locale
     * @var string
     */
    public $Locale;
    /**
     * The Timezone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Timezone;
    /**
     * Constructor method for Localization
     * @uses Localization::setLocale()
     * @uses Localization::setTimezone()
     * @param string $locale
     * @param string $timezone
     */
    public function __construct($locale = null, $timezone = null)
    {
        $this
            ->setLocale($locale)
            ->setTimezone($timezone);
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \StructType\Localization
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Get Timezone value
     * @return string|null
     */
    public function getTimezone()
    {
        return $this->Timezone;
    }
    /**
     * Set Timezone value
     * @param string $timezone
     * @return \StructType\Localization
     */
    public function setTimezone($timezone = null)
    {
        // validation for constraint: string
        if (!is_null($timezone) && !is_string($timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timezone, true), gettype($timezone)), __LINE__);
        }
        $this->Timezone = $timezone;
        return $this;
    }
}
