<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfString StructType
 * @subpackage Structs
 */
class ListOfString extends ModifiablePropertyType
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Value;
    /**
     * The encoding
     * @var string
     */
    public $encoding;
    /**
     * Constructor method for ListOfString
     * @uses ListOfString::setValue()
     * @uses ListOfString::setEncoding()
     * @param string[] $value
     * @param string $encoding
     */
    public function __construct(array $value = array(), $encoding = null)
    {
        $this
            ->setValue($value)
            ->setEncoding($encoding);
    }
    /**
     * Get Value value
     * @return string[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfStringValueItem) {
            // validation for constraint: itemType
            if (!is_string($listOfStringValueItem)) {
                $invalidValues[] = is_object($listOfStringValueItem) ? get_class($listOfStringValueItem) : sprintf('%s(%s)', gettype($listOfStringValueItem), var_export($listOfStringValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param string[] $value
     * @return \StructType\ListOfString
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ListOfString
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @uses \EnumType\StringEncodingType::valueIsValid()
     * @uses \EnumType\StringEncodingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encoding
     * @return \StructType\ListOfString
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StringEncodingType::valueIsValid($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StringEncodingType', is_array($encoding) ? implode(', ', $encoding) : var_export($encoding, true), implode(', ', \EnumType\StringEncodingType::getValidValues())), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
}
