<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfObject StructType
 * @subpackage Structs
 */
class ListOfObject extends ModifiablePropertyType
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DependentObjectType[]
     */
    public $Value;
    /**
     * The listMode
     * @var string
     */
    public $listMode;
    /**
     * Constructor method for ListOfObject
     * @uses ListOfObject::setValue()
     * @uses ListOfObject::setListMode()
     * @param \StructType\DependentObjectType[] $value
     * @param string $listMode
     */
    public function __construct(array $value = array(), $listMode = null)
    {
        $this
            ->setValue($value)
            ->setListMode($listMode);
    }
    /**
     * Get Value value
     * @return \StructType\DependentObjectType[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfObjectValueItem) {
            // validation for constraint: itemType
            if (!$listOfObjectValueItem instanceof \StructType\DependentObjectType) {
                $invalidValues[] = is_object($listOfObjectValueItem) ? get_class($listOfObjectValueItem) : sprintf('%s(%s)', gettype($listOfObjectValueItem), var_export($listOfObjectValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \StructType\DependentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param \StructType\DependentObjectType[] $value
     * @return \StructType\ListOfObject
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \StructType\DependentObjectType $item
     * @return \StructType\ListOfObject
     */
    public function addToValue(\StructType\DependentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DependentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type \StructType\DependentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Get listMode value
     * @return string|null
     */
    public function getListMode()
    {
        return $this->listMode;
    }
    /**
     * Set listMode value
     * @param string $listMode
     * @return \StructType\ListOfObject
     */
    public function setListMode($listMode = null)
    {
        // validation for constraint: string
        if (!is_null($listMode) && !is_string($listMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listMode, true), gettype($listMode)), __LINE__);
        }
        $this->listMode = $listMode;
        return $this;
    }
}
