<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfFloat64 StructType
 * @subpackage Structs
 */
class ListOfFloat64 extends ModifiablePropertyType
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $Value;
    /**
     * Constructor method for ListOfFloat64
     * @uses ListOfFloat64::setValue()
     * @param float[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return float[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfFloat64ValueItem) {
            // validation for constraint: itemType
            if (!(is_float($listOfFloat64ValueItem) || is_numeric($listOfFloat64ValueItem))) {
                $invalidValues[] = is_object($listOfFloat64ValueItem) ? get_class($listOfFloat64ValueItem) : sprintf('%s(%s)', gettype($listOfFloat64ValueItem), var_export($listOfFloat64ValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type double, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param float[] $value
     * @return \StructType\ListOfFloat64
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \StructType\ListOfFloat64
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type double, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
