<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstallAddOnAction StructType
 * @subpackage Structs
 */
class InstallAddOnAction extends ActionType
{
    /**
     * The addOnId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}
     * - use: required
     * @var string
     */
    public $addOnId;
    /**
     * Constructor method for InstallAddOnAction
     * @uses InstallAddOnAction::setAddOnId()
     * @param string $addOnId
     */
    public function __construct($addOnId = null)
    {
        $this
            ->setAddOnId($addOnId);
    }
    /**
     * Get addOnId value
     * @return string
     */
    public function getAddOnId()
    {
        return $this->addOnId;
    }
    /**
     * Set addOnId value
     * @param string $addOnId
     * @return \StructType\InstallAddOnAction
     */
    public function setAddOnId($addOnId = null)
    {
        // validation for constraint: string
        if (!is_null($addOnId) && !is_string($addOnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnId, true), gettype($addOnId)), __LINE__);
        }
        // validation for constraint: pattern(\{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\})
        if (!is_null($addOnId) && !preg_match('/\\{[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}\\}/', $addOnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}', var_export($addOnId, true)), __LINE__);
        }
        $this->addOnId = $addOnId;
        return $this;
    }
}
